/*
 * Copyright (c) 2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.data;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;

import jp.sf.orangesignal.csv.CsvConfig;
import jp.sf.orangesignal.csv.handlers.ColumnNameMappingBeanListHandler;
import jp.sf.orangesignal.ta.data.CsvDataConfig;
import jp.sf.orangesignal.ta.data.CsvFileType;
import jp.sf.orangesignal.ta.data.CsvPriceLoader;
import jp.sf.orangesignal.ta.data.model.Price;

import org.junit.Test;

/**
 * {@link CsvPriceLoader} クラスの単体テストです。
 * 
 * @author 杉澤 浩二
 */
public class CsvPriceLoaderTest {

	@Test
	public void test1() throws IOException {
		final CsvDataConfig csvDataConfig = new CsvDataConfig();
		csvDataConfig.setPath("src/test/resources/data");
		csvDataConfig.setEncoding("Windows-31J");

		final CsvConfig csvConfig = new CsvConfig();
		csvConfig.setIgnoreEmptyLines(true);
		csvDataConfig.setCsvConfig(csvConfig);

		final CsvPriceLoader loader = new CsvPriceLoader();
		loader.setConfig(csvDataConfig);
		loader.setHandler(
			new ColumnNameMappingBeanListHandler<Price>(Price.class)
				.addColumn("日付", "date", new SimpleDateFormat("yyyy/MM/dd"))
				.addColumn("始値", "open")
				.addColumn("高値", "high")
				.addColumn("安値", "low")
				.addColumn("終値", "close")
				.addColumn("出来高", "volume")
		);

//		assertThat(loader.listed("n225"), is(true));
		final List<? extends Price> list  = loader.load("n225");
		assertThat(list.size(), is(2694));
		final Price p0 = list.get(0);
		assertThat(p0.getClose().intValue(), is(14956));
	}

	@Test
	public void test2() throws IOException {
		final CsvDataConfig csvDataConfig = new CsvDataConfig();
		csvDataConfig.setPath("src/test/resources/data");
		csvDataConfig.setType(CsvFileType.ZIP);
		csvDataConfig.setEncoding("Windows-31J");

		final CsvConfig csvConfig = new CsvConfig();
		csvConfig.setIgnoreEmptyLines(true);
		csvDataConfig.setCsvConfig(csvConfig);

		final CsvPriceLoader loader = new CsvPriceLoader();
		loader.setConfig(csvDataConfig);
		loader.setHandler(
			new ColumnNameMappingBeanListHandler<Price>(Price.class)
				.addColumn("日付", "date", new SimpleDateFormat("yyyy/MM/dd"))
				.addColumn("始値", "open")
				.addColumn("高値", "high")
				.addColumn("安値", "low")
				.addColumn("終値", "close")
				.addColumn("出来高", "volume")
		);

//		assertThat(loader.listed("n225"), is(true));
		final List<? extends Price> list  = loader.load("n225");
		assertThat(list.size(), is(2694));
		final Price p0 = list.get(0);
		assertThat(p0.getClose().intValue(), is(14956));
	}

}
