/*
 * Copyright (c) 2008-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.data;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertThat;

import java.util.Calendar;

import org.junit.Test;

/**
 * {@link DateTruncater} クラスの単体テストです。
 * 
 * @author 杉澤 浩二
 */
public class DateTruncaterTest {

	@Test
	public void testDateTruncater() {
		new DateTruncater();
	}

	@Test
	public void testGetYear() {
		assertThat(new DateTruncater().getYear(), is(1970));
	}

	@Test
	public void testSetYear() {
		final DateTruncater truncater = new DateTruncater();
		truncater.setYear(2009);
		assertThat(truncater.getYear(), is(2009));
	}

	@Test
	public void testGetMonth() {
		assertThat(new DateTruncater().getMonth(), is(Calendar.JANUARY));
	}

	@Test
	public void testSetMonth() {
		final DateTruncater truncater = new DateTruncater();
		truncater.setMonth(Calendar.AUGUST);
		assertThat(truncater.getMonth(), is(Calendar.AUGUST));
	}

	@Test
	public void testGetDate() {
		assertThat(new DateTruncater().getDate(), is(1));
	}

	@Test
	public void testSetDate() {
		final DateTruncater truncater = new DateTruncater();
		truncater.setDate(4);
		assertThat(truncater.getDate(), is(4));
	}

	@Test
	public void testGetHour() {
		assertThat(new DateTruncater().getHour(), is(0));
	}

	@Test
	public void testSetHour() {
		final DateTruncater truncater = new DateTruncater();
		truncater.setHour(22);
		assertThat(truncater.getHour(), is(22));
	}

	@Test
	public void testGetMinute() {
		assertThat(new DateTruncater().getMinute(), is(0));
	}

	@Test
	public void testSetMinute() {
		final DateTruncater truncater = new DateTruncater();
		truncater.setMinute(7);
		assertThat(truncater.getMinute(), is(7));
	}

	@Test
	public void testGetSecond() {
		assertThat(new DateTruncater().getSecond(), is(0));
	}

	@Test
	public void testSetSecond() {
		final DateTruncater truncater = new DateTruncater();
		truncater.setSecond(15);
		assertThat(truncater.getSecond(), is(15));
	}

	@Test
	public void testGetMillisecond() {
		assertThat(new DateTruncater().getMillisecond(), is(0));
	}

	@Test
	public void testSetMillisecond() {
		final DateTruncater truncater = new DateTruncater();
		truncater.setMillisecond(528);
		assertThat(truncater.getMillisecond(), is(528));
	}

	@Test
	public void testTruncate() {
		final DateTruncater truncater = new DateTruncater();
		final Calendar in = Calendar.getInstance();
		Calendar out;

		out = truncater.truncate(in, Calendar.ERA);
		assertNotNull(out);
		assertThat(out.get(Calendar.YEAR), is(truncater.getYear()));
		assertThat(out.get(Calendar.MONTH), is(truncater.getMonth()));
		assertThat(out.get(Calendar.DATE), is(truncater.getDate()));
		assertThat(out.get(Calendar.HOUR_OF_DAY), is(truncater.getHour()));
		assertThat(out.get(Calendar.MINUTE), is(truncater.getMinute()));
		assertThat(out.get(Calendar.SECOND), is(truncater.getSecond()));
		assertThat(out.get(Calendar.MILLISECOND), is(truncater.getMillisecond()));

		out = truncater.truncate(in, Calendar.YEAR);
		assertNotNull(out);
		assertThat(out.get(Calendar.YEAR), is(truncater.getYear()));
		assertThat(out.get(Calendar.MONTH), is(truncater.getMonth()));
		assertThat(out.get(Calendar.DATE), is(truncater.getDate()));
		assertThat(out.get(Calendar.HOUR_OF_DAY), is(truncater.getHour()));
		assertThat(out.get(Calendar.MINUTE), is(truncater.getMinute()));
		assertThat(out.get(Calendar.SECOND), is(truncater.getSecond()));
		assertThat(out.get(Calendar.MILLISECOND), is(truncater.getMillisecond()));

		out = truncater.truncate(in, Calendar.MONTH);
		assertNotNull(out);
		assertThat(out.get(Calendar.YEAR), is(in.get(Calendar.YEAR)));
		assertThat(out.get(Calendar.MONTH), is(truncater.getMonth()));
		assertThat(out.get(Calendar.DATE), is(truncater.getDate()));
		assertThat(out.get(Calendar.HOUR_OF_DAY), is(truncater.getHour()));
		assertThat(out.get(Calendar.MINUTE), is(truncater.getMinute()));
		assertThat(out.get(Calendar.SECOND), is(truncater.getSecond()));
		assertThat(out.get(Calendar.MILLISECOND), is(truncater.getMillisecond()));

		out = truncater.truncate(in, Calendar.DAY_OF_WEEK);
		assertNotNull(out);
		assertThat(out.get(Calendar.YEAR), is(in.get(Calendar.YEAR)));
		assertThat(out.get(Calendar.MONTH), is(in.get(Calendar.MONTH)));
		assertThat(out.get(Calendar.DATE), is((in.get(Calendar.DATE) + in.getFirstDayOfWeek() - in.get(Calendar.DAY_OF_WEEK))));
		assertThat(out.get(Calendar.HOUR_OF_DAY), is(truncater.getHour()));
		assertThat(out.get(Calendar.MINUTE), is(truncater.getMinute()));
		assertThat(out.get(Calendar.SECOND), is(truncater.getSecond()));
		assertThat(out.get(Calendar.MILLISECOND), is(truncater.getMillisecond()));

		out = truncater.truncate(in, Calendar.DATE);
		assertNotNull(out);
		assertThat(out.get(Calendar.YEAR), is(in.get(Calendar.YEAR)));
		assertThat(out.get(Calendar.MONTH), is(in.get(Calendar.MONTH)));
		assertThat(out.get(Calendar.DATE), is(truncater.getDate()));
		assertThat(out.get(Calendar.HOUR_OF_DAY), is(truncater.getHour()));
		assertThat(out.get(Calendar.MINUTE), is(truncater.getMinute()));
		assertThat(out.get(Calendar.SECOND), is(truncater.getSecond()));
		assertThat(out.get(Calendar.MILLISECOND), is(truncater.getMillisecond()));

		out = truncater.truncate(in, Calendar.DAY_OF_MONTH);
		assertNotNull(out);
		assertThat(out.get(Calendar.YEAR), is(in.get(Calendar.YEAR)));
		assertThat(out.get(Calendar.MONTH), is(in.get(Calendar.MONTH)));
		assertThat(out.get(Calendar.DATE), is(truncater.getDate()));
		assertThat(out.get(Calendar.HOUR_OF_DAY), is(truncater.getHour()));
		assertThat(out.get(Calendar.MINUTE), is(truncater.getMinute()));
		assertThat(out.get(Calendar.SECOND), is(truncater.getSecond()));
		assertThat(out.get(Calendar.MILLISECOND), is(truncater.getMillisecond()));

		out = truncater.truncate(in, Calendar.AM_PM);
		assertNotNull(out);
		assertThat(out.get(Calendar.YEAR), is(in.get(Calendar.YEAR)));
		assertThat(out.get(Calendar.MONTH), is(in.get(Calendar.MONTH)));
		assertThat(out.get(Calendar.DATE), is(in.get(Calendar.DATE)));
		assertThat(out.get(Calendar.HOUR_OF_DAY), is(truncater.getHour()));
		assertThat(out.get(Calendar.MINUTE), is(truncater.getMinute()));
		assertThat(out.get(Calendar.SECOND), is(truncater.getSecond()));
		assertThat(out.get(Calendar.MILLISECOND), is(truncater.getMillisecond()));

		out = truncater.truncate(in, Calendar.HOUR);
		assertNotNull(out);
		assertThat(out.get(Calendar.YEAR), is(in.get(Calendar.YEAR)));
		assertThat(out.get(Calendar.MONTH), is(in.get(Calendar.MONTH)));
		assertThat(out.get(Calendar.DATE), is(in.get(Calendar.DATE)));
		assertThat(out.get(Calendar.HOUR_OF_DAY), is(truncater.getHour()));
		assertThat(out.get(Calendar.MINUTE), is(truncater.getMinute()));
		assertThat(out.get(Calendar.SECOND), is(truncater.getSecond()));
		assertThat(out.get(Calendar.MILLISECOND), is(truncater.getMillisecond()));

		out = truncater.truncate(in, Calendar.HOUR_OF_DAY);
		assertNotNull(out);
		assertThat(out.get(Calendar.YEAR), is(in.get(Calendar.YEAR)));
		assertThat(out.get(Calendar.MONTH), is(in.get(Calendar.MONTH)));
		assertThat(out.get(Calendar.DATE), is(in.get(Calendar.DATE)));
		assertThat(out.get(Calendar.HOUR_OF_DAY), is(truncater.getHour()));
		assertThat(out.get(Calendar.MINUTE), is(truncater.getMinute()));
		assertThat(out.get(Calendar.SECOND), is(truncater.getSecond()));
		assertThat(out.get(Calendar.MILLISECOND), is(truncater.getMillisecond()));

		out = truncater.truncate(in, Calendar.MINUTE);
		assertNotNull(out);
		assertThat(out.get(Calendar.YEAR), is(in.get(Calendar.YEAR)));
		assertThat(out.get(Calendar.MONTH), is(in.get(Calendar.MONTH)));
		assertThat(out.get(Calendar.DATE), is(in.get(Calendar.DATE)));
		assertThat(out.get(Calendar.HOUR_OF_DAY), is(in.get(Calendar.HOUR_OF_DAY)));
		assertThat(out.get(Calendar.MINUTE), is(truncater.getMinute()));
		assertThat(out.get(Calendar.SECOND), is(truncater.getSecond()));
		assertThat(out.get(Calendar.MILLISECOND), is(truncater.getMillisecond()));

		out = truncater.truncate(in, Calendar.SECOND);
		assertNotNull(out);
		assertThat(out.get(Calendar.YEAR), is(in.get(Calendar.YEAR)));
		assertThat(out.get(Calendar.MONTH), is(in.get(Calendar.MONTH)));
		assertThat(out.get(Calendar.DATE), is(in.get(Calendar.DATE)));
		assertThat(out.get(Calendar.HOUR_OF_DAY), is(in.get(Calendar.HOUR_OF_DAY)));
		assertThat(out.get(Calendar.MINUTE), is(in.get(Calendar.MINUTE)));
		assertThat(out.get(Calendar.SECOND), is(truncater.getSecond()));
		assertThat(out.get(Calendar.MILLISECOND), is(truncater.getMillisecond()));

		out = truncater.truncate(in, Calendar.MILLISECOND);
		assertNotNull(out);
		assertThat(out.get(Calendar.YEAR), is(in.get(Calendar.YEAR)));
		assertThat(out.get(Calendar.MONTH), is(in.get(Calendar.MONTH)));
		assertThat(out.get(Calendar.DATE), is(in.get(Calendar.DATE)));
		assertThat(out.get(Calendar.HOUR_OF_DAY), is(in.get(Calendar.HOUR_OF_DAY)));
		assertThat(out.get(Calendar.MINUTE), is(in.get(Calendar.MINUTE)));
		assertThat(out.get(Calendar.SECOND), is(in.get(Calendar.SECOND)));
		assertThat(out.get(Calendar.MILLISECOND), is(truncater.getMillisecond()));
	}

}
