package jp.sf.orangesignal.ta.data.sample;

import jp.sf.orangesignal.ta.data.CompressType;
import jp.sf.orangesignal.ta.data.annotation.DateItem;
import jp.sf.orangesignal.ta.data.annotation.DatePattern;
import jp.sf.orangesignal.ta.data.annotation.NumberCompressorType;
import jp.sf.orangesignal.ta.data.annotation.NumberItem;
import jp.sf.orangesignal.ta.data.annotation.NumberPattern;

@DatePattern(value = "yyyy/MM/dd", language = "ja", country = "JP", timezone = "Asia/Tokyo")
@NumberPattern(value = "#,##0", language = "ja", country = "JP", currency = "JPY")
@NumberCompressorType(CompressType.SUM)
public class StringDataset {

	@DateItem
	@DatePattern(value = "yyyy/MM/dd", language = "ja", country = "JP", timezone = "Asia/Tokyo")
	public String[] date;

	@NumberItem
	@NumberPattern(value = "#,##0", language = "ja", country = "JP", currency = "JPY")
	@NumberCompressorType(CompressType.FIRST)
	public String[] open;

	@NumberItem
	@NumberPattern(value = "#,##0", language = "ja", country = "JP", currency = "JPY")
	@NumberCompressorType(CompressType.HIGHEST)
	public String[] high;

	@NumberItem
	@NumberPattern(value = "#,##0", language = "ja", country = "JP", currency = "JPY")
	@NumberCompressorType(CompressType.LOWEST)
	public String[] low;

	@NumberItem
	@NumberPattern(value = "#,##0", language = "ja", country = "JP", currency = "JPY")
	@NumberCompressorType(CompressType.LAST)
	public String[] close;

	@NumberItem
	@NumberPattern(value = "#,##0", language = "ja", country = "JP")
	@NumberCompressorType(CompressType.SUM)
	public String[] volume;

}
