/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.trading;

/**
 * トレードの種類を表す列挙型を提供します。
 * 
 * @author 杉澤 浩二
 */
public enum TradeType {

	/**
	 * 買い注文と買い注文の決済が可能である事を表します。
	 */
	LONG {
		@Override public boolean isLong() { return true; }
		@Override public boolean isShort() { return false; }
		@Override public boolean isReverse() { return false; }
	},

	/**
	 * 売り注文と売り注文の決済が可能である事を表します。
	 */
	SHORT {
		@Override public boolean isLong() { return false; }
		@Override public boolean isShort() { return true; }
		@Override public boolean isReverse() { return false; }
	},

	/**
	 * 買い注文と売り注文及び途転(ドテン)を含めない決済が可能である事を表します。
	 */
	LONG_AND_SHORT {
		@Override public boolean isLong() { return true; }
		@Override public boolean isShort() { return true; }
		@Override public boolean isReverse() { return false; }
	},

	/**
	 * 買い注文と売り注文及び途転(ドテン)を含めた決済が可能である事を表します。
	 */
	LONG_AND_SHORT_AND_REVERSE {
		@Override public boolean isLong() { return true; }
		@Override public boolean isShort() { return true; }
		@Override public boolean isReverse() { return true; }
	};

	/**
	 * この列挙型が買い注文可能であるかどうかを返します。
	 * 
	 * @return 買い注文が可能である場合は <code>true</code> それ以外の場合は <code>false</code>
	 */
	public abstract boolean isLong();

	/**
	 * この列挙型が売り注文可能であるかどうかを返します。
	 * 
	 * @return 売り注文が可能である場合は <code>true</code> それ以外の場合は <code>false</code>
	 */
	public abstract boolean isShort();

	/**
	 * この列挙型が途転(ドテン)可能であるかどうかを返します。
	 * 
	 * @return 途転(ドテン)が可能である場合は <code>true</code> それ以外の場合は <code>false</code>
	 */
	public abstract boolean isReverse();

}
