/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.trading.order;

import java.util.Date;

/**
 * 翌日に逆指値注文する注文情報を提供します。
 * 
 * @author 杉澤 浩二
 */
public final class NextStopOrder extends AbstractOrder implements StopOrder {

	private static final long serialVersionUID = -5175090887180579083L;

	/**
	 * コンストラクタです。
	 * 
	 * @param symbol シンボル
	 * @param label ラベル
	 * @param date 注文日時
	 * @param stop 逆指値
	 * @param quantity 数量
	 * @param findId 決済注文ID
	 * @param findLabel 決済注文ラベル
	 * @throws NullPointerException パラメーターに <code>null</code> を指定した場合
	 * @throws IllegalArgumentException 逆指値に <code>0</code> 以下の値を指定した場合
	 */
	public NextStopOrder(
			final String symbol,
			final String label,
			final Date date,
			final double stop,
			final int quantity,
			final Integer findId,
			final String findLabel)
	{
		super(symbol, label, date, quantity, findId, findLabel);

		if (stop <= 0)
			throw new IllegalArgumentException();
		this.stopPrice = stop;
	}

	/**
	 * 実装は必ず {@link OrderType#STOP} を返します。
	 */
	@Override public final OrderType getOrderType() { return OrderType.STOP; }

	/**
	 * この実装は必ず <code>1</code> を返します。
	 */
	@Override public int getPeriod() { return 1; }

	/**
	 * 逆指値を保持します。
	 */
	private double stopPrice;

	@Override public double getStopPrice() { return stopPrice; }

}
