/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.trading.strategy.systems;

import static jp.sf.orangesignal.ta.CrossSignal.DEAD_CROSS;

/**
 * 価格と移動平均のデッドクロスで買いポジションを決済するストラテジーを提供します。
 */
public class MovingAverageCrossLongExit extends MovingAverageCross {

	@Override
	public boolean execute() {
		final int i = getCurrentDataIndex();
		if (cross[i] != null && cross[i] == DEAD_CROSS)
			sell(getStrategyName());
		return false;
	}

}
