package jp.sf.orangesignal.trading.commission;

import static org.junit.Assert.assertTrue;
import jp.sf.orangesignal.trading.commission.CommissionUnit;
import jp.sf.orangesignal.trading.commission.FixedCommission;

import org.apache.commons.lang.SerializationUtils;
import org.junit.Test;

public class FixedCommissionTest {

	@Test
	public void testFixedCommission() {
		new FixedCommission();
		assertTrue(true);
	}

	@Test
	public void testFixedCommissionDouble() {
		new FixedCommission(50);
		assertTrue(true);
	}

	@Test
	public void testFixedCommissionDoubleDouble() {
		new FixedCommission(10000, 50);
		assertTrue(true);
	}

	@Test
	public void testFixedCommissionDoubleDoubleDoubleDouble() {
		new FixedCommission(10000, 50, 1000, 5);
		assertTrue(true);
	}

	@Test
	public void testFixedCommissionDoubleDoubleDoubleDoubleDouble() {
		new FixedCommission(10000, 50, 1000, 5, 2500);
		assertTrue(true);
	}

	@Test
	public void testGetCommission() {
		assertTrue(new FixedCommission().getCommission() == 0D);
		assertTrue(new FixedCommission(50).getCommission() == 50D);
		assertTrue(new FixedCommission(10000, 50).getCommission() == 50D);
		assertTrue(new FixedCommission(10000, 50, 1000, 5).getCommission() == 50D);
		assertTrue(new FixedCommission(10000, 50, 1000, 5, 2500).getCommission() == 50D);
	}

	@Test
	public void testSetCommission() {
		final FixedCommission commission = new FixedCommission();
		commission.setCommission(50);
		assertTrue(commission.getCommission() == 50D);
	}

	@Test
	public void testGetStep() {
		assertTrue(new FixedCommission().getStep() == 0D);
		assertTrue(new FixedCommission(50).getStep() == 0D);
		assertTrue(new FixedCommission(10000, 50).getStep() == 0D);
		assertTrue(new FixedCommission(10000, 50, 1000, 5).getStep() == 1000D);
		assertTrue(new FixedCommission(10000, 50, 1000, 5, 2500).getStep() == 1000D);
	}

	@Test
	public void testSetStep() {
		final FixedCommission commission = new FixedCommission();
		commission.setStep(1000);
		assertTrue(commission.getStep() == 1000D);
	}

	@Test
	public void testGetAdding() {
		assertTrue(new FixedCommission().getAdding() == 0D);
		assertTrue(new FixedCommission(50).getAdding() == 0D);
		assertTrue(new FixedCommission(10000, 50).getAdding() == 0D);
		assertTrue(new FixedCommission(10000, 50, 1000, 5).getAdding() == 5D);
		assertTrue(new FixedCommission(10000, 50, 1000, 5, 2500).getAdding() == 5D);
	}

	@Test
	public void testSetAdding() {
		final FixedCommission commission = new FixedCommission();
		commission.setAdding(5);
		assertTrue(commission.getAdding() == 5D);
	}

	@Test
	public void testGetMax() {
		assertTrue(new FixedCommission().getMax() == 0D);
		assertTrue(new FixedCommission(50).getMax() == 0D);
		assertTrue(new FixedCommission(10000, 50).getMax() == 0D);
		assertTrue(new FixedCommission(10000, 50, 1000, 5).getMax() == 0D);
		assertTrue(new FixedCommission(10000, 50, 1000, 5, 2500).getMax() == 2500D);
	}

	@Test
	public void testSetMax() {
		final FixedCommission commission = new FixedCommission();
		commission.setMax(15000);
		assertTrue(commission.getMax() == 15000D);
	}

	@Test
	public void testCalcCommission() {
		assertTrue(new FixedCommission().calcCommission(10000, 100) == 0D);
		assertTrue(new FixedCommission(50).calcCommission(10000, 100) == 50D);
		assertTrue(new FixedCommission(10000, 50).calcCommission(10000, 100) == 50D);
		assertTrue(new FixedCommission(10000, 50, 1000, 5).calcCommission(10000, 100) == 5000D);
		assertTrue(new FixedCommission(10000, 50, 1000, 5, 2500).calcCommission(10000, 100) == 2500D);
	}

	@Test
	public void testGetBase() {
		assertTrue(new FixedCommission().getBase() == 0D);
		assertTrue(new FixedCommission(50).getBase() == 0D);
		assertTrue(new FixedCommission(10000, 50).getBase() == 10000D);
		assertTrue(new FixedCommission(10000, 50, 1000, 5).getBase() == 10000D);
		assertTrue(new FixedCommission(10000, 50, 1000, 5, 2500).getBase() == 10000D);
	}

	@Test
	public void testSetBase() {
		final FixedCommission commission = new FixedCommission();
		commission.setBase(10000);
		assertTrue(commission.getBase() == 10000D);
	}

	@Test
	public void testCompareTo() {
		final CommissionUnit commission0 = new FixedCommission(10000, 50);
		final CommissionUnit commission1 = new FixedCommission(10000, 50);
		final CommissionUnit commission2 = new FixedCommission(15000, 100);
		final CommissionUnit commission3 = new FixedCommission(20000, 200);
		assertTrue(commission1.compareTo(commission0) == 0);
		assertTrue(commission1.compareTo(commission1) == 0);
		assertTrue(commission1.compareTo(commission2) < 0);
		assertTrue(commission1.compareTo(commission3) < 0);
		assertTrue(commission3.compareTo(commission0) > 0);
	}

	@Test(expected = NullPointerException.class)
	public void testCompareToNullPointerException() {
		new FixedCommission().compareTo(null);
	}

	@Test
	public void testSerialization() {
		final byte[] bytes = SerializationUtils.serialize(new FixedCommission());
		assertTrue(true);
		final Object obj = SerializationUtils.deserialize(bytes);
		assertTrue(obj instanceof FixedCommission);
	}

}
