struct TILEVERTEX {
	float3 PosL		: POSITION;
	float3 NormL	: NORMAL;
	float2 TCrd0	: TEXCOORD0;
	float2 TCrd1	: TEXCOORD1;
};

struct VSOut {
	float4 PosH		: SV_POSITION;
	float2 TCrd0	: TEXCOORD0;
};

cbuffer cb_VS_CelBackground		: register( b0 )
{
	row_major matrix WVP;		//64
};

VSOut VS_CelBackground( TILEVERTEX In ) {
	VSOut Out;
	Out.PosH = mul( float4( In.PosL, 1.0f ), WVP );
	Out.TCrd0 = In.TCrd0;
	return Out;
}

Texture2D DiffuseTex;

SamplerState MainSampler;

cbuffer cb_PS_CelBackground		: register( b1 )
{
	float4 cColor;				//16
};

float4 PS_CelBackground( VSOut In )	: SV_Target
{
	return float4( cColor.r*(DiffuseTex.Sample( MainSampler, In.TCrd0 ).rgb - 0.05f), cColor.a );
}