#define sMix 0.5f

struct MESH_VERTEX {
	float3 PosL		: POSITION;
};

struct VSOut {
	float4 PosH		: SV_POSITION;
};

cbuffer cb_VS_Shadow	: register( b0 )
{
	row_major matrix WVP;
};

VSOut VS_Shadow( MESH_VERTEX In ) {
	VSOut Out;
	Out.PosH = mul( float4( In.PosL, 1.0f ), WVP );
	return Out;
}

cbuffer cb_PS_Shadow	: register( b0 )
{
	float4 alpha;
};

float4 PS_Shadow( VSOut In )	: SV_Target
{
	return float4( 0.0f, 0.0f, 0.0f, alpha.x );
}