struct PARTICLE_VERTEX {
	float3 PosW		: POSITION;
	float size		: TEXCOORD0;
	float mix		: TEXCOORD1;
	uint tidx		: TEXCOORD2;
};

struct VSOut {
	float3 PosW		: POSITION;
	float size		: TEXCOORD0;
	float mix		: TEXCOORD1;
	uint tidx		: TEXCOORD2;
};

VSOut VS_Particle( PARTICLE_VERTEX In ) {
	VSOut Out;
	Out.PosW = In.PosW;
	Out.size = In.size;
	Out.mix = In.mix;
	Out.tidx = In.tidx;
	return Out;
}

//=====================================================
//				Geometry shader:
//=====================================================

cbuffer cb_GS_Particle_0		: register( b0 )
{
	row_major matrix VP;	//64
	float4 Light;			//80

	uint isShadow;
	float3 cCDir;			//96
};

//=====================================================
//
struct GSOut {
	float4 PosH		: SV_POSITION;
	float2 TCrd		: TEXCOORD0;
	float Light		: TEXCOORD1;
	float mix		: TEXCOORD2;
	uint PrimID		: SV_PrimitiveID;
};

[maxvertexcount(4)]
void GS_Particle( point VSOut In[1], uint PrimID : SV_PrimitiveID, inout TriangleStream<GSOut> triStream )
{	
	static const half4 tu[8] = {
		half4( 0.0f, 0.5f, 0.5f, 0.0f ),
		half4( 0.5f, 1.0f, 1.0f, 0.5f ),
		half4( 0.0f, 0.5f, 0.5f, 0.0f ),
		half4( 0.5f, 1.0f, 1.0f, 0.5f ),

		half4( 0.5f, 0.5f, 0.0f, 0.0f ),
		half4( 1.0f, 1.0f, 0.5f, 0.5f ),
		half4( 0.5f, 0.5f, 0.0f, 0.0f ),
		half4( 1.0f, 1.0f, 0.5f, 0.5f )
	};

	static const half4 tv[8] = {
		half4( 0.0f, 0.0f, 0.5f, 0.5f ),
		half4( 0.0f, 0.0f, 0.5f, 0.5f ),
		half4( 0.5f, 0.5f, 1.0f, 1.0f ),
		half4( 0.5f, 0.5f, 1.0f, 1.0f ),

		half4( 0.0f, 0.5f, 0.5f, 0.0f ),
		half4( 0.0f, 0.5f, 0.5f, 0.0f ),
		half4( 0.5f, 1.0f, 1.0f, 0.5f ),
		half4( 0.5f, 1.0f, 1.0f, 0.5f )
	};

	float3 u = float3( 0.0f, 0.0f, 0.0f );
	float3 v = float3( 0.0f, 0.0f, 0.0f );
	float3 cdir;

	if( isShadow == 1 )	cdir = cCDir;
	else				cdir = In[0].PosW;
	
	if( cdir.y || cdir.z ) {
		u.y = cdir.z;
		u.z = -cdir.y;
		float len = In[0].size/sqrt( u.y*u.y + u.z*u.z );
		u *= len;
		v.x = cdir.y*cdir.y + cdir.z*cdir.z;
		v.y = -cdir.x*cdir.y;
		v.z = -cdir.x*cdir.z;
		len = In[0].size/length( v );
		v *= len;
	}
	else {
		u.y = In[0].size;
		v.z = In[0].size;
	}

	GSOut Out;

	Out.PosH = mul( float4( (In[0].PosW - u + v), 1.0f ), VP );
	Out.TCrd = float2( tu[In[0].tidx].y, tv[In[0].tidx].y );
	Out.Light = Light.y;
	Out.mix = In[0].mix;
	Out.PrimID = PrimID;
	triStream.Append( Out );

	Out.PosH = mul( float4( (In[0].PosW - u - v), 1.0f ), VP );
	Out.TCrd = float2( tu[In[0].tidx].x, tv[In[0].tidx].x );
	Out.Light = Light.x;
	Out.mix = In[0].mix;
	Out.PrimID = PrimID;
	triStream.Append( Out );

	Out.PosH = mul( float4( (In[0].PosW + u + v), 1.0f ), VP );
	Out.TCrd = float2( tu[In[0].tidx].z, tv[In[0].tidx].z );
	Out.Light = Light.z;
	Out.mix = In[0].mix;
	Out.PrimID = PrimID;
	triStream.Append( Out );

	Out.PosH = mul( float4( (In[0].PosW + u - v), 1.0f ), VP );
	Out.TCrd = float2( tu[In[0].tidx].w, tv[In[0].tidx].w );
	Out.Light = Light.w;
	Out.mix = In[0].mix;
	Out.PrimID = PrimID;
	triStream.Append( Out );
}

//=====================================================
//				Pixel shaders:
//=====================================================

cbuffer cb_PS_per_stream			: register( b0 )
{
	float4 cColor;
};

Texture2D ParticleTex;
SamplerState ParticleSampler;

//=====================================================
//		Pixel shader for diffuse particles:
float4 PS_Particle_D( GSOut In )		: SV_Target
{
	float4 TexCol = ParticleTex.Sample( ParticleSampler, In.TCrd );
	return float4( TexCol.rgb*In.Light, TexCol.a*In.mix );
}

//=====================================================
//		Pixel shader for emissive particles:
float4 PS_Particle_E( GSOut In )		: SV_Target
{
	float4 TexCol = ParticleTex.Sample( ParticleSampler, In.TCrd );
	return float4( TexCol.rgb*cColor.rgb, TexCol.a*In.mix );
}

float4 PS_Particle_S( GSOut In )		: SV_Target
{
	float4 TexCol = ParticleTex.Sample( ParticleSampler, In.TCrd );
	return float4( 0.0f, 0.0f, 0.0f, TexCol.a*In.mix );
}