struct TILEVERTEX {
	float3 PosL		: POSITION;
	float3 NormL	: NORMAL;
	float2 TCrd0	: TEXCOORD0;
	float2 TCrd1	: TEXCOORD1;
};

struct VSOut {
	float4 PosH		: SV_POSITION;
	float2 TCrd0	: TEXCOORD0;
	float2 TCrd1	: TEXCOORD1;

	float diff		: TEXCOORD2;	//atm
	float ambi		: TEXCOORD3;
	float4 diffuse	: TEXCOORD4;	//surf
	float4 toCamW	: TEXCOORD5;
	float4 NormW	: TEXCOORD6;
};

cbuffer cb_VS_Clouds_0	: register( b0 )
{
	float3 cSunDir;			//16
	float nothing;
	
	float cDispersion;
	float cSunAppRad;
	float cAmbient0;
	float cGlobalAmb;		//32
};

cbuffer cb_VS_Clouds_1	: register( b1 )
{
	row_major matrix W;		//64
	row_major matrix VP;	//128
};

void LegacySunColor( out half4 diff, out float ambi, in float3 NormW ) {
	float h = dot( -cSunDir, NormW );
	float3 r0 = 1.0f - float3( 0.4f, 0.65f, 1.0f )*cDispersion;

	if( cDispersion > 0.0 ) {	// case 1: planet has atmosphere
		float3 di = (r0 + (1.0f - r0)*saturate( h*5.78 ))*saturate( (h + cSunAppRad)/(2.0*cSunAppRad) );
		float ni = (h + 0.242)*2.924;
		float ambi = saturate( max( cAmbient0*saturate( ni ) - 0.05, cGlobalAmb ) );
		diff = float4( di*(1.0f - ambi*0.5), 1.0f );
	}
	else {						// case 2: planet has no atmosphere
		diff = float4( r0*saturate( (h + cSunAppRad)/(2.0f*cSunAppRad) ), 1.0f );
		ambi = cGlobalAmb;
	}
}

VSOut VS_Clouds( TILEVERTEX In ) {
	VSOut Out;
	float4 PosW = mul( float4( In.PosL, 1.0f ), W );	
	Out.toCamW = normalize( -PosW );
	Out.PosH = mul( PosW, VP );
	Out.TCrd0 = In.TCrd0;
	Out.TCrd1 = In.TCrd1;

	Out.NormW = normalize( mul( float4( In.NormL, 0.0f ), W ) );
	Out.diff = saturate( dot( -cSunDir, Out.NormW )*1.5f );	
	
	LegacySunColor( Out.diffuse, Out.ambi, Out.NormW );
	return Out;
}

Texture2D CloudTexture;
Texture2D CloudMicroTexture;

SamplerState MainSampler;
SamplerState MicroSampler;

cbuffer cb_PS_Clouds_0		: register( b0 )
{	
	float cMix;
	float3 nodata2;			//16
};

//======================================
//		without microtexture
//======================================

float4 PS_Clouds_0( VSOut In ) : SV_Target
{
	float mic = 1.0f;

	float4 data = float4( 1.0f, 1.0f, 1.0f, 1.0f );
	data *= In.ambi;
	float4 color = CloudTexture.Sample( MainSampler, In.TCrd0 );

	[branch]
	if( dot( In.NormW, In.toCamW ) < 0 ) {
		float4 diff = (min( 1.0f, In.diff*6.0f )*In.diffuse) + data;
		return float4( color.rgb*diff.rgb, color.a*mic );
	}
	else {
		float4 diff = (min( 1.0f, In.diff*2.0f )*In.diffuse) + data;
		return float4( color.rgb*diff.rgb, color.a*mic );
	}
}

//======================================
//		with microtexture
//======================================

float4 PS_Clouds_1( VSOut In ) : SV_Target
{
	float mic = 1.0f;
	mic -= (1.0f - CloudMicroTexture.Sample( MicroSampler, In.TCrd1 ).a)*cMix*0.5f;

	float4 data = float4( 1.0f, 1.0f, 1.0f, 1.0f );
	data *= In.ambi;
	float4 color = CloudTexture.Sample( MainSampler, In.TCrd0 );

	[branch]
	if( dot( In.NormW, In.toCamW ) < 0 ) {
		float4 diff = (min( 1.0f, In.diff*6.0f )*In.diffuse) + data;
		return float4( color.rgb*diff.rgb, color.a*mic );
	}
	else {
		float4 diff = (min( 1.0f, In.diff*2.0f )*In.diffuse) + data;
		return float4( color.rgb*diff.rgb, color.a*mic );
	}
}