struct TILEVERTEX {
	float3 PosL		: POSITION;
	float3 NormL	: NORMAL;
	float2 TCrd0	: TEXCOORD0;
	float2 TCrd1	: TEXCOORD1;
};

struct VSOut {
	float4 PosH		: SV_POSITION;
	float2 TCrd0	: TEXCOORD0;
	float2 TCrd1	: TEXCOORD1;
	float4 atten	: TEXCOORD2;
};

cbuffer cb_VS_CloudShadow_0	: register( b0 )
{
	uint cHazeMode;
	float cFogDensity;
	float2 nodata;		//16
};

cbuffer cb_VS_CloudShadow_1	: register( b1 )
{
	row_major matrix W;		//64
	row_major matrix VP;	//128
};

VSOut VS_CloudsShadow( TILEVERTEX In ) {
	VSOut Out;
	Out.PosH = mul( mul( float4( In.PosL, 1.0f ), W ), VP );
	Out.TCrd0 = In.TCrd0;
	Out.TCrd1 = In.TCrd1;

	float4 none;

	[branch]
	if( cHazeMode == 0 )	Out.atten = 1;
	else					Out.atten = 1.0f / exp( Out.PosH.z*cFogDensity);	//FogFactor

	return Out;
}

cbuffer cb_PS_CloudShadow	: register( b0 )
{
	float Mix;
	float3 nodata2;
};

Texture2D MainTexture;
Texture2D MicroTexture;

SamplerState	MainSampler;
SamplerState	MicroSampler;

//======================================
//		without microtexture
//======================================

float4 PS_CloudsShadow_0( VSOut In )	: SV_Target
{
	return float4( 0.0f, 0.0f, 0.0f, MainTexture.Sample( MainSampler, In.TCrd0  ).a*In.atten.b );
}

//======================================
//		with microtexture
//======================================

float4 PS_CloudsShadow_1( VSOut In )	: SV_Target
{
	float mic = MicroTexture.Sample( MicroSampler, In.TCrd1 ).a*Mix;
	return float4( 0.0f, 0.0f, 0.0f, (1.0f - mic)*MainTexture.Sample( MainSampler, In.TCrd0 ).a*In.atten.b );
}