struct HVERTEX {
	float3 PosL		: POSITION;
	float4 color	: TEXCOORD0;
	float tex		: TEXCOORD1;
};

struct VSOut {
	float4 PosH		: SV_POSITION;
	float4 color	: TEXCOORD0;
	float tex		: TEXCOORD1;
};

cbuffer cb_VS		: register( b0 )
{
	row_major matrix WVP;	//64
};

VSOut VS_Haze( HVERTEX In ) {
	VSOut Out;
	Out.PosH = mul( float4( In.PosL, 1.0f ), WVP );
	Out.color = In.color;
	Out.tex = In.tex;
	return Out;
}

float4 PS_Haze( VSOut In ) : SV_Target {
	return float4( In.color.rgb*(In.tex + 0.3), In.color.a*In.tex*In.tex );
}