struct RVERTEX {
	float3 PosL		: POSITION;
	float2 TCrd		: TEXCOORD;
};

struct VSOut {
	float4 PosH		: SV_POSITION;
	float2 TCrd		: TEXCOORD0;

	float3 CamW		: TEXCOORD1;
};

cbuffer cb_VS_Ring	: register( b0 )
{
	row_major matrix W;		//64
	row_major matrix VP;	//128
};

VSOut VS_Ring( RVERTEX In ) {
	VSOut Out;
	float4 PosW = mul( float4( In.PosL, 1.0f ), W );
	Out.PosH = mul( PosW, VP );
	Out.CamW = -PosW.xyz;
	Out.TCrd = In.TCrd;
	return Out;
}

cbuffer cb_PS_Ring	: register( b0 )
{
	float4 NormW;			//16	//normalize !
};

Texture2D	RingTexture;
SamplerState	RingSampler;

float4 PS_Ring( VSOut In )	: SV_Target
{
	float4 color = RingTexture.Sample( RingSampler, In.TCrd );
	[branch]
	if( dot( NormW, normalize( In.CamW ) ) > 0 )	//... ????
		return float4( color.rgb*0.35f, color.a ); 
	return color;
}