struct BBVERTEX {
	float3 PosL		: POSITION;
	float2 TCrd		: TEXCOORD;
};

struct VSOut {
	float4 PosH		: SV_POSITION;
	float2 TCrd		: TEXCOORD;
};

cbuffer cb_VS		: register( b0 )
{
	row_major matrix WVP;
};

VSOut VS_BillBoard( BBVERTEX In ) {
	VSOut Out;
	Out.PosH = mul( float4( In.PosL, 1.0f ), WVP );
//	Out.PosH.z -= 0.5f;
	Out.TCrd = In.TCrd;
	return Out;
};

cbuffer cb_PS		: register( b0 )
{	
	float3 cColor;
	float cMix;
};

Texture2D Sprite;
SamplerState Linear;

float4 PS_BillBoard( VSOut In )	: SV_Target
{
	float4 col = Sprite.Sample( Linear, In.TCrd );
	return float4( col.rgb*cColor, col.a*cMix );
}