#ifndef __CLOUDMGR_H
#define __CLOUDMGR_H

#if C2504
#pragma message("CloudManager.h");
#endif

#include "TileManager.h"

class vPlanet;
class TileManager;

class CloudManager : public TileManager {
public:
	CloudManager( vPlanet *_planet );
	~CloudManager();

	void SaveParams( D3DXMATRIX *wmat, double scale, int level, double viewap = 0.0 );
	void SaveParamsShadows( D3DXMATRIX *wmat, double scale, int level, double viewap, float shadow_alpha );
	void Render( bool above );
	void RenderShadow(/* D3DXMATRIX *wmat, double scale, int level, double viewap, float shadowalpha */);
private:
	void InitRenderTile();
	void EndRenderTile();

	void RenderSimple( int lvl, int npatch, TILEDESC *tile, D3DXMATRIX *mWorld );
	void RenderTile( int hemisphere, int lvl, int ilat, int nlat, int ilng, int nlng, /*double sdist,*/ TILEDESC *tile,
		const TEXCRDRANGE &range, ID3D11ShaderResourceView *tex, ID3D11ShaderResourceView *ltex, DWORD flag );
	
	int cloudtexidx;
	D3DXMATRIX M[2];	//MT

	RENDERPARAM RP1;
};

#endif