#ifndef _GDIPAD_H
#define _GDIPAD_H

#include "D3D11Client.h"

// ======================================================================
//							GDI Sketchpad
// ======================================================================

class GDIPad: public oapi::Sketchpad {
public:
	GDIPad( SURFHANDLE srf, HDC hdc );
	~GDIPad();

	oapi::Font *SetFont( oapi::Font *font ) const;
	oapi::Pen *SetPen( oapi::Pen *pen ) const;
	oapi::Brush *SetBrush( oapi::Brush *brush ) const;

	void SetTextAlign( TAlign_horizontal tah = LEFT, TAlign_vertical tav = TOP );
	DWORD SetTextColor( DWORD col );
	DWORD SetBackgroundColor( DWORD col );
	void SetBackgroundMode( BkgMode mode );
	DWORD GetCharSize();
	DWORD GetTextWidth( const char *str, int len = 0 );
	void SetOrigin( int x, int y ); 
	bool Text( int x, int y, const char *str, int len );
	bool TextBox( int x1, int y1, int x2, int y2, const char *str, int len );
	void Pixel( int x, int y, DWORD col );
	void MoveTo( int x, int y );
	void LineTo( int x, int y );
	void Line( int x0, int y0, int x1, int y1 );
	void Rectangle( int x0, int y0, int x1, int y1 );
	void Ellipse( int x0, int y0, int x1, int y1 );
	void Polygon( const oapi::IVECTOR2 *pt, int npt );
	void Polyline( const oapi::IVECTOR2 *pt, int npt );
	void PolyPolygon( const oapi::IVECTOR2 *pt, const int *npt, const int nline );
	void PolyPolyline( const oapi::IVECTOR2 *pt, const int *npt, const int nline );
	HDC GetDC()	{ return hDC; }
private:
	HDC hDC;
	mutable HFONT hFont0;
	mutable oapi::Font *cfont;
	mutable oapi::Pen *cpen;
	mutable oapi::Brush *cbrush;
};
/*
class  GDIFont: public oapi::Font {
	friend class GDIPad;
public:
	GDIFont( int height, bool prop, const char *face, Style style = NORMAL, int orientation = 0 );
	~GDIFont();
	HFONT GetGDIFont() const {	return hFont;	}
private:
	HFONT hFont;
};

class  GDIPen: public oapi::Pen {
	friend class GDIPad;
public:
	GDIPen( int style, int width, DWORD col );
	~GDIPen();
private:
	HPEN hPen;
};

class GDIBrush: public oapi::Brush {
	friend class GDIPad;
public:
	GDIBrush( DWORD col );
	~GDIBrush();
private:
	HBRUSH hBrush;
};
*/
#endif