#ifndef __SURFMGR_H
#define __SURFMGR_H

#if C2504
#pragma message("SurfManager.h")
#endif

#include "TileManager.h"
#include "CloudManager.h"
#include "CelSphere.h"

class SurfaceManager: public TileManager {
public:
	SurfaceManager( vPlanet *_planet );
	~SurfaceManager();

	void SetMicrotexture( const char *fname );

	void Render( /*D3DXMATRIX &wmat, double scale, int level, double viewap = 0.0, bool bfog = false*/ );
protected:
	void InitRenderTile();
	void EndRenderTile();

	void RenderSimple( int lvl, int npatch, TILEDESC *tile, D3DXMATRIX *mWorld );
	void RenderTile( int hemisphere, int lvl, int ilat, int nlat, int ilng, int nlng, /*double sdist,*/ TILEDESC *tile,
		const TEXCRDRANGE &range, ID3D11ShaderResourceView *tex, ID3D11ShaderResourceView *ltex, DWORD flag );

	float fAmbient;

	FogParam Fog;
	bool bFog;
	DWORD Shader_prev;
};

#define HORIZON_NSEG 128

struct HVERTEX {
	D3DXVECTOR3 pos;	//12
	D3DXCOLOR col;		//28
	float tex;			//32
};

class HazeManager : public D3D11Effect {
public:
	HazeManager( vPlanet *_planet );
	~HazeManager();

	static void GlobalInit( D3D11Config *_cfg );
	static void GlobalExit();

	void SaveParams();
	void Render( D3DXMATRIX *wmat, bool dual );
private:
	vPlanet *planet;
	OBJHANDLE obj;
	double rad;

	ATMCONST *atmc;
	D3DXCOLOR basecol;
	double hralt, dens0, hshift, cloudalt;
	float hscale;

	static ID3D11Buffer *VB, *IB;
	static DWORD nIdx;
	static HVERTEX *_VB;
//	static HVERTEX _VB[HORIZON_NSEG*2];
	static float CosP[HORIZON_NSEG], SinP[HORIZON_NSEG];

	static D3D11Config *cfg;

//MT:
	MATRIX3 grot;
	VECTOR3 gpos;
};

#endif