#include "D3D11Client.h"

VideoTab *VTab;

VideoTab::VideoTab( D3D11Client *_gc, D3D11Config *_cfg, HWND _hTab, HINSTANCE _hDLL ) {
	hTab = _hTab;
	hDLL = _hDLL;
	gc = _gc;
	cfg = _cfg;
	aspect = 0;

	aspect_wfac[0] = 4;
	aspect_wfac[1] = 16;
	aspect_wfac[2] = 16;

	aspect_hfac[0] = 3;
	aspect_hfac[1] = 10;
	aspect_hfac[2] = 9;

	VTab = this;
	hConfig = hGeneral = hVessels = hPlanets = NULL;

	InitVideoTab();
}

VideoTab::~VideoTab() {
	delete [ ] ModeDesc;
}

BOOL VideoTab::LaunchpadVideoWndProc( HWND hwnd, UINT msg, WPARAM wp, LPARAM lp ) {

	static WINDOWPOS *wpos;
	static RECT TabRect;

	vdata = gc->GetVideoData();

	switch( msg ) {
	case WM_INITDIALOG:
		return TRUE;
	case WM_COMMAND:
		switch( LOWORD(wp) ) {
		case VID_DEVICE://*
			if( HIWORD(wp) == CBN_SELCHANGE ) {
				SelectOutput();
			}
			break;
		case VID_MODE:
			if( HIWORD( wp ) == CBN_SELCHANGE ) {
				SelectMode();
				return TRUE;
			}
			break;
		case VID_FULL:
			if( HIWORD(wp) == BN_CLICKED ) {
				SelectFullscreen( true );
				return TRUE;
			}
			break;
		case VID_WINDOW:
			if( HIWORD(wp) == BN_CLICKED ) {
				SelectFullscreen( false );
				return TRUE;
			}
			break;
		case VID_WIDTH:
			if( HIWORD(wp) == EN_CHANGE ) {
				SelectWidth();
				return TRUE;
			}
			break;
		case VID_HEIGHT:
			if( HIWORD( wp ) == EN_CHANGE ) {
				SelectHeight();
				return TRUE;
			}
			break;
		case VID_ASPECT:
			if( HIWORD( wp ) == BN_CLICKED ) {
				SelectWidth();
				return TRUE;
			}
			break;
		case VID_PAGEFLIP://full screen window.
			if( HIWORD( wp ) == BN_CLICKED ) {
				SelectFullScreenWindow();
				return TRUE;
			}
			break;
		case VID_ENUM://software device.
			if( HIWORD( wp ) == BN_CLICKED ) {
				SelectSoftwareDevice();
				return TRUE;
			}
			break;
		case VID_4X3:
		case VID_16X10:
		case VID_16X9:
			if( HIWORD( wp ) == BN_CLICKED ) {
				aspect = LOWORD( wp ) - VID_4X3;
				SelectWidth();
				return TRUE;
			}
			break;
		case VID_VSYNC:
			if( HIWORD( wp ) == BN_CLICKED ) {
				return TRUE;
			}
			break;
		case VID_STENCIL:
			if( HIWORD( wp ) == BN_CLICKED ) {
				return TRUE;
			}
			break;
		case VID_D3D11CONFIG:
			if( HIWORD( wp ) == BN_CLICKED ) {
				if( hConfig )
					return TRUE;
				InitConfigWindow();
				return TRUE;
			}
			break;
		}
		break;
	case WM_WINDOWPOSCHANGED:

		wpos = (WINDOWPOS*)lp;
		GetWindowRect( hTab, &TabRect );
		int
			tab_width = abs( TabRect.right - TabRect.left ),
			tab_height = abs( TabRect.bottom - TabRect.top );

		if( tab_width < 420 )			tab_width = 420;
		if( tab_height < 408 )			tab_height = 408;
		BOOL res = MoveWindow( GetDlgItem( hTab, VID_D3D11CONFIG ), 7 + (tab_width - 420)/2, 305 + (tab_height - 408)/2, 407, 50, true );
		return FALSE;
	}
	return FALSE;
}

void VideoTab::SelectFullScreenWindow() {
	if( cfg->FullScreenWindow ) {
		SendDlgItemMessage( hTab, VID_PAGEFLIP, BM_SETCHECK, 0, 0 );
		cfg->FullScreenWindow = vdata->pageflip = false;
	}
	else {
		SendDlgItemMessage( hTab, VID_PAGEFLIP, BM_SETCHECK, 1, 0 );
		cfg->FullScreenWindow = vdata->pageflip = true;
	}
}

void VideoTab::SelectSoftwareDevice() {
	static bool HardWare;

	HardWare = ( cfg->DriverType == D3D_DRIVER_TYPE_UNKNOWN );
	vdata->forceenum = !HardWare;
	if( HardWare ) {
		SendDlgItemMessage( hTab, VID_ENUM, BM_SETCHECK, 1, 0 );
		cfg->DriverType = D3D_DRIVER_TYPE_REFERENCE;
	}
	else {
		SendDlgItemMessage( hTab, VID_ENUM, BM_SETCHECK, 0, 0 );
		cfg->DriverType = D3D_DRIVER_TYPE_UNKNOWN;
	}
}

void VideoTab::SelectWidth() {
	if( SendDlgItemMessage( hTab, VID_ASPECT, BM_GETCHECK, 0, 0 ) == BST_CHECKED ) {
		char cbuf[32];
		int w, h, wfac = aspect_wfac[aspect], hfac = aspect_hfac[aspect];
		GetWindowTextA( GetDlgItem( hTab, VID_WIDTH ), cbuf, 127 );
		w = atoi( cbuf );
		GetWindowTextA( GetDlgItem( hTab, VID_HEIGHT ), cbuf, 127 );
		h = atoi( cbuf );
		if( w != (wfac*h)/hfac ) {
			h = (hfac*w)/wfac;
			if( _itoa_s( h, cbuf, 32, 10 ) )
				return;
			SetWindowTextA( GetDlgItem( hTab, VID_HEIGHT ), cbuf );
			vdata->winh = h;
		}
		cfg->Width = w;
		cfg->Height = h;
	}
}

void VideoTab::SelectHeight() {
	if( SendDlgItemMessage( hTab, VID_ASPECT, BM_GETCHECK, 0, 0 ) == BST_CHECKED ) {
		char cbuf[32];
		int w, h, wfac = aspect_wfac[aspect], hfac = aspect_hfac[aspect];
		GetWindowTextA( GetDlgItem( hTab, VID_WIDTH ), cbuf, 127 );
		w = atoi( cbuf );
		GetWindowTextA( GetDlgItem( hTab, VID_HEIGHT ), cbuf, 127 );
		h = atoi( cbuf );
		if( h != (hfac*w)/wfac ) {
			w = (wfac*h)/hfac;
			if( _itoa_s( w, cbuf, 32, 10 ) )
				return;
			SetWindowTextA( GetDlgItem( hTab, VID_WIDTH ), cbuf );
			vdata->winw = w;
		}
		cfg->Width = w;
		cfg->Height = h;
	}
}

void VideoTab::InitTextBoxes() {
	char cbuf[32];
	vdata = gc->GetVideoData();

	if( _itoa_s( vdata->winw, cbuf, 32, 10 ) )		return;
	SetWindowTextA( GetDlgItem( hTab, VID_WIDTH ), cbuf );
//height.
	if( _itoa_s( vdata->winh, cbuf, 32, 10 ) )		return;
	SetWindowTextA( GetDlgItem( hTab, VID_HEIGHT ), cbuf );
}

void VideoTab::SelectFullscreen( bool fullscreen ) {
	cfg->FullScreenWindow = vdata->fullscreen = fullscreen;
	if( fullscreen ) {
		SendDlgItemMessage( hTab, VID_FULL, BM_SETCHECK, 1, 0 );
		SendDlgItemMessage( hTab, VID_WINDOW, BM_SETCHECK, 0, 0 );

		EnableWindow( GetDlgItem( hTab, VID_ASPECT ), false );
		EnableWindow( GetDlgItem( hTab, VID_WIDTH ), false );
		EnableWindow( GetDlgItem( hTab, VID_HEIGHT ), false );
		EnableWindow( GetDlgItem( hTab, VID_4X3 ), false );
		EnableWindow( GetDlgItem( hTab, VID_16X10 ), false );
		EnableWindow( GetDlgItem( hTab, VID_16X9 ), false );
		EnableWindow( GetDlgItem( hTab, VID_MODE ), true );
		EnableWindow( GetDlgItem( hTab, VID_VSYNC ), true );
		EnableWindow( GetDlgItem( hTab, VID_PAGEFLIP ), true );
	}
	else {
		SendDlgItemMessage( hTab, VID_FULL, BM_SETCHECK, 0, 0 );
		SendDlgItemMessage( hTab, VID_WINDOW, BM_SETCHECK, 1, 0 );

		EnableWindow( GetDlgItem( hTab, VID_ASPECT ), true );
		EnableWindow( GetDlgItem( hTab, VID_WIDTH ), true );
		EnableWindow( GetDlgItem( hTab, VID_HEIGHT ), true );
		EnableWindow( GetDlgItem( hTab, VID_4X3 ), true );
		EnableWindow( GetDlgItem( hTab, VID_16X10 ), true );
		EnableWindow( GetDlgItem( hTab, VID_16X9 ), true );
		EnableWindow( GetDlgItem( hTab, VID_MODE ), false );
		EnableWindow( GetDlgItem( hTab, VID_VSYNC ), false );
		EnableWindow( GetDlgItem( hTab, VID_PAGEFLIP ), false );
	}
}

void VideoTab::SelectOutput() {
	static char line[256];

	vdata->deviceidx = SendDlgItemMessage( hTab, VID_DEVICE, CB_GETCURSEL, 0, 0 );
	cfg->Adapter = cfg->Adapters[vdata->deviceidx];
	cfg->Output = cfg->Outputs[vdata->deviceidx];

	SendDlgItemMessage( hTab, VID_MODE, CB_RESETCONTENT, 0, 0 );
	delete [ ] ModeDesc;
	UINT NumModes;
	cfg->Outputs[vdata->deviceidx]->GetDisplayModeList( DXGI_FORMAT_B8G8R8A8_UNORM, 0, &NumModes, NULL );
	ModeDesc = new DXGI_MODE_DESC [NumModes];
	cfg->Outputs[vdata->deviceidx]->GetDisplayModeList( DXGI_FORMAT_B8G8R8A8_UNORM, 0, &NumModes, ModeDesc );
	for( DWORD j = 0; j < NumModes; j++ ) {
		if( ModeDesc[j].Scaling )
			continue;
		if( ModeDesc[j].ScanlineOrdering != 1 )
			continue;
		sprintf( line, "%u x %u %u Hz", ModeDesc[j].Width, ModeDesc[j].Height, (int)((float)ModeDesc[j].RefreshRate.Numerator/(float)ModeDesc[j].RefreshRate.Denominator + 0.3 ), ModeDesc[j].Scaling, ModeDesc[j].ScanlineOrdering );
		SendDlgItemMessageA( hTab, VID_MODE, CB_ADDSTRING, 0, (LPARAM)line );
		SendDlgItemMessageA( hTab, VID_MODE, CB_SETITEMDATA, j, (LPARAM)( ModeDesc[j].Width<<16 | ModeDesc[j].Height ) );
	}
	SendDlgItemMessage( hTab, VID_MODE, CB_SETCURSEL, 0, 0 );
}

void VideoTab::SelectMode() {
	vdata->modeidx = SendDlgItemMessage( hTab, VID_MODE, CB_GETCURSEL, 0, 0 );
	cfg->Width = ModeDesc[vdata->modeidx].Width;
	cfg->Height = ModeDesc[vdata->modeidx].Height;
}

void VideoTab::UpdateConfig() {
	char cbuf[32];
	vdata = gc->GetVideoData();

	vdata->deviceidx  = SendDlgItemMessage( hTab, VID_DEVICE, CB_GETCURSEL, 0, 0 );
	vdata->modeidx    = SendDlgItemMessage( hTab, VID_MODE, CB_GETCURSEL, 0, 0 );
	vdata->fullscreen = ( SendDlgItemMessage( hTab, VID_FULL, BM_GETCHECK, 0, 0 ) == BST_CHECKED );
	vdata->novsync    = ( SendDlgItemMessage( hTab, VID_VSYNC, BM_GETCHECK, 0, 0 ) == BST_CHECKED );
	vdata->pageflip   = ( SendDlgItemMessage( hTab, VID_PAGEFLIP, BM_GETCHECK, 0, 0 ) == BST_CHECKED );
	vdata->trystencil = ( SendDlgItemMessage( hTab, VID_STENCIL, BM_GETCHECK, 0, 0 ) == BST_CHECKED );
	vdata->forceenum  = ( SendDlgItemMessage( hTab, VID_ENUM, BM_GETCHECK, 0, 0 ) == BST_CHECKED );

	GetWindowTextA(GetDlgItem(hTab, VID_WIDTH),  cbuf, 32);
	vdata->winw = atoi(cbuf);
	GetWindowTextA(GetDlgItem(hTab, VID_HEIGHT), cbuf, 32);
	vdata->winh = atoi(cbuf);
}

void VideoTab::InitVideoTab() {
	char line[256];
	DWORD aCounter = 0, oCounter = 0;
		
	vdata = gc->GetVideoData();
	SendDlgItemMessage( hTab, VID_DEVICE, CB_RESETCONTENT, 0, 0);
	SendDlgItemMessage( hTab, VID_MODE, CB_RESETCONTENT, 0, 0 );

	for( UINT j = 0; j < cfg->NumOutputs; j++ ) {
		SendDlgItemMessageA( hTab, VID_DEVICE, CB_ADDSTRING, 0, (LPARAM)cfg->AdapterOutputDesc[j] );
	}
	SendDlgItemMessageA( hTab, VID_DEVICE, CB_SETCURSEL, vdata->deviceidx, 0 );
//display modes.
	UINT NumModes;
	cfg->Outputs[vdata->deviceidx]->GetDisplayModeList( DXGI_FORMAT_B8G8R8A8_UNORM, 0, &NumModes, NULL );
	ModeDesc = new DXGI_MODE_DESC [NumModes];
	cfg->Outputs[vdata->deviceidx]->GetDisplayModeList( DXGI_FORMAT_B8G8R8A8_UNORM, 0, &NumModes, ModeDesc );
	for( DWORD j = 0; j < NumModes; j++ ) {
		if( ModeDesc[j].Scaling )
			continue;
		if( ModeDesc[j].ScanlineOrdering != 1 )
			continue;
		sprintf( line, "%u x %u %u Hz", ModeDesc[j].Width, ModeDesc[j].Height, (int)((float)ModeDesc[j].RefreshRate.Numerator/(float)ModeDesc[j].RefreshRate.Denominator + 0.3 ), ModeDesc[j].Scaling, ModeDesc[j].ScanlineOrdering );
		SendDlgItemMessageA( hTab, VID_MODE, CB_ADDSTRING, 0, (LPARAM)line );
		SendDlgItemMessageA( hTab, VID_MODE, CB_SETITEMDATA, j, (LPARAM)( ModeDesc[j].Width<<16 | ModeDesc[j].Height ) );
	}
	SendDlgItemMessage( hTab, VID_MODE, CB_SETCURSEL, (WPARAM)vdata->modeidx, 0 );
//software device.
	SendDlgItemMessageA( hTab, VID_ENUM, CB_RESETCONTENT, 0, 0 );
	SetWindowTextA( GetDlgItem( hTab, VID_ENUM ), "" );
	SendDlgItemMessageA( hTab, VID_ENUM, BM_SETCHECK, vdata->forceenum, 0 );
//aspect.
	if( vdata->winw == (4*vdata->winh)/3 || vdata->winh == (3*vdata->winw)/4 )
		aspect = 1;
	if( vdata->winw == (16*vdata->winh)/10 || vdata->winh == (10*vdata->winw)/16 )
		aspect = 2;
	if( vdata->winw == (16*vdata->winh)/9 || vdata->winh == (9*vdata->winw)/16 )
		aspect = 3;

	SendDlgItemMessageA( hTab, VID_ASPECT, BM_SETCHECK, aspect ? 1 : 0, 0 );
	if( aspect )
		aspect--;
	SendDlgItemMessageA( hTab, VID_4X3+aspect, BM_SETCHECK, 1, 0 );
//
	SendDlgItemMessageA( hTab, VID_STENCIL, BM_SETCHECK, 0, 0 );
	SendDlgItemMessageA( hTab, VID_VSYNC, BM_SETCHECK, 0, 0 );
//pass parameters to D3D11Config class. [TODO]
	SendDlgItemMessageA( hTab, VID_VSYNC, CB_RESETCONTENT, 0, 0 );
	SetWindowTextA( GetDlgItem( hTab, VID_VSYNC ), "" );
	SendDlgItemMessageA( hTab, VID_VSYNC, BM_SETCHECK, vdata->novsync, 0 );
//full screen window.
	SendDlgItemMessageA( hTab, VID_PAGEFLIP, CB_RESETCONTENT, 0, 0 );
	SetWindowTextA( GetDlgItem( hTab, VID_PAGEFLIP ), "" );
	SendDlgItemMessageA( hTab, VID_PAGEFLIP, BM_SETCHECK, vdata->pageflip, 0 );
//stencil.
	SendDlgItemMessageA( hTab, VID_STENCIL, CB_RESETCONTENT, 0, 0 );
	SetWindowTextA( GetDlgItem( hTab, VID_STENCIL ), "" );
	SendDlgItemMessageA( hTab, VID_STENCIL, BM_SETCHECK, vdata->trystencil, 0 );
//sets 32bit into BPP combobox.
	EnableWindow( GetDlgItem( hTab, VID_BPP ), false );
	SendDlgItemMessageA( hTab, VID_BPP, CB_RESETCONTENT, 0, 0 );
	SendDlgItemMessageA( hTab, VID_BPP, CB_ADDSTRING, 0, (LPARAM)"32" );
	SendDlgItemMessageA( hTab, VID_BPP, CB_SETCURSEL, 0, 0 );

	EnableWindow( GetDlgItem( hTab, VID_FULL ), false );
	EnableWindow( GetDlgItem( hTab, VID_STENCIL ), false );
	EnableWindow( GetDlgItem( hTab, VID_PAGEFLIP ), false );
	EnableWindow( GetDlgItem( hTab, VID_VSYNC ), false );
	EnableWindow( GetDlgItem( hTab, VID_ENUM ), false );
	
//fulscreen.
	SendDlgItemMessage( hTab, VID_FULL, BM_SETCHECK, vdata->fullscreen, 0 );
	SendDlgItemMessage( hTab, VID_WINDOW, BM_SETCHECK, !vdata->fullscreen, 0 );
	if( vdata->fullscreen ) {
		EnableWindow( GetDlgItem( hTab, VID_ASPECT ), false );
		EnableWindow( GetDlgItem( hTab, VID_WIDTH ), false );
		EnableWindow( GetDlgItem( hTab, VID_HEIGHT ), false );
		EnableWindow( GetDlgItem( hTab, VID_4X3 ), false );
		EnableWindow( GetDlgItem( hTab, VID_16X10 ), false );
		EnableWindow( GetDlgItem( hTab, VID_16X9 ), false );
		EnableWindow( GetDlgItem( hTab, VID_MODE ), true );
		EnableWindow( GetDlgItem( hTab, VID_VSYNC ), true );
		EnableWindow( GetDlgItem( hTab, VID_PAGEFLIP ), true );
	}
	else {
		EnableWindow( GetDlgItem( hTab, VID_ASPECT ), true );
		EnableWindow( GetDlgItem( hTab, VID_WIDTH ), true );
		EnableWindow( GetDlgItem( hTab, VID_HEIGHT ), true );
		EnableWindow( GetDlgItem( hTab, VID_4X3 ), true );
		EnableWindow( GetDlgItem( hTab, VID_16X10 ), true );
		EnableWindow( GetDlgItem( hTab, VID_16X9 ), true );
		EnableWindow( GetDlgItem( hTab, VID_MODE ), false );
		EnableWindow( GetDlgItem( hTab, VID_VSYNC ), false );
		EnableWindow( GetDlgItem( hTab, VID_PAGEFLIP ), false );
	}

	CreateWindowA( "button", "D3D11Client Configuration", WS_CHILD | BS_PUSHBUTTON, 5, 310, 407, 50, hTab, (HMENU)VID_D3D11CONFIG, hDLL, 0 );
	HFONT hFont = (HFONT)GetStockObject( DEFAULT_GUI_FONT );
	SendMessage( GetDlgItem( hTab, VID_D3D11CONFIG ), WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));
//	GetWindowRect( hTab, &InitTabRect );

	ShowWindow( GetDlgItem( hTab, VID_D3D11CONFIG ), SW_SHOW );
	EnableWindow( GetDlgItem( hTab, VID_D3D11CONFIG ), true );
}

//================================================================
//			"D3D11Client configuration"
//================================================================

LRESULT CALLBACK _ConfigProc( HWND hwnd, UINT msg, WPARAM wp, LPARAM lp ) {
	return VTab->ConfigProc( hwnd, msg, wp, lp );
}

LRESULT CALLBACK _GeneralProc( HWND hwnd, UINT msg, WPARAM wp, LPARAM lp ) {
	return VTab->GeneralProc( hwnd, msg, wp, lp );
}

LRESULT CALLBACK _VesselProc( HWND hwnd, UINT msg, WPARAM wp, LPARAM lp ) {
	return VTab->VesselProc( hwnd, msg, wp, lp );
}

LRESULT CALLBACK _PlanetsProc( HWND hwnd, UINT msg, WPARAM wp, LPARAM lp ) {
	return VTab->PlanetProc( hwnd, msg, wp, lp );
}

LRESULT VideoTab::ConfigProc( HWND hwnd, UINT msg, WPARAM wp, LPARAM lp ) {
	switch( msg ) {
	case WM_DESTROY:
		hConfig = NULL;
		return TRUE;

	case WM_COMMAND:

		switch( LOWORD( wp ) ) {
		case CTRL_OK:
			if( HIWORD( wp ) == BN_CLICKED ) {
				memcpy( &cfg->Cfg, &Cfg, sizeof(D3D11CONFIG) );
				cfg->SaveConfig();			//writes config to file
				cfg->ApplyConfig();
				DestroyWindow( hConfig );	//destroys itself
				hConfig = NULL;
				return TRUE;
			}
			break;
		case CTRL_CANCEL:
			if( HIWORD( wp ) == BN_CLICKED ) {
				DestroyWindow( hConfig );
				hConfig = NULL;
				return TRUE;
			}
			break;
		case CTRL_GENERAL:
			if( HIWORD( wp ) == BN_CLICKED ) {
				EnableWindow( hGeneral, true );
				EnableWindow( hVessels, false );
				EnableWindow( hPlanets, false );
				ShowWindow( hGeneral, true );
				ShowWindow( hVessels, false );
				ShowWindow( hPlanets, false );
				SendDlgItemMessage( hConfig, CTRL_GENERAL, BM_SETCHECK, 1, 0 );
				SendDlgItemMessage( hConfig, CTRL_VESSELS, BM_SETCHECK, 0, 0 );
				SendDlgItemMessage( hConfig, CTRL_PLANETS, BM_SETCHECK, 0, 0 );
				return TRUE;
			}
			break;
		case CTRL_VESSELS:
			if( HIWORD( wp ) == BN_CLICKED ) {
				EnableWindow( hGeneral, false );
				EnableWindow( hVessels, true );
				EnableWindow( hPlanets, false );
				ShowWindow( hGeneral, false );
				ShowWindow( hVessels, true );
				ShowWindow( hPlanets, false );
				SendDlgItemMessage( hConfig, CTRL_GENERAL, BM_SETCHECK, 0, 0 );
				SendDlgItemMessage( hConfig, CTRL_VESSELS, BM_SETCHECK, 1, 0 );
				SendDlgItemMessage( hConfig, CTRL_PLANETS, BM_SETCHECK, 0, 0 );
				return TRUE;
			}
			break;
		case CTRL_PLANETS:
			if( HIWORD( wp ) == BN_CLICKED ) {
				EnableWindow( hGeneral, false );
				EnableWindow( hVessels, false );
				EnableWindow( hPlanets, true );
				ShowWindow( hGeneral, false );
				ShowWindow( hVessels, false );
				ShowWindow( hPlanets, true );
				SendDlgItemMessage( hConfig, CTRL_GENERAL, BM_SETCHECK, 0, 0 );
				SendDlgItemMessage( hConfig, CTRL_VESSELS, BM_SETCHECK, 0, 0 );
				SendDlgItemMessage( hConfig, CTRL_PLANETS, BM_SETCHECK, 1, 0 );
				return TRUE;
			}
			break;
		}

	}
	return DefWindowProcA( hwnd, msg, wp, lp );
}

LRESULT VideoTab::GeneralProc( HWND hwnd, UINT msg, WPARAM wp, LPARAM lp ) {
	static char cbuf[32];
	static float transp;

	switch( msg ) {
	case WM_COMMAND:

		switch( LOWORD( wp ) ) {
		case CTRL_G_THREADS:
			if( HIWORD( wp ) == CBN_SELCHANGE ) {
				Cfg.Thread_mode = SendDlgItemMessage( hGeneral, CTRL_G_THREADS, CB_GETCURSEL, 0, 0 );
				return TRUE;
			}
			break;
		case CTRL_G_AA:
			if( HIWORD( wp ) == CBN_SELCHANGE ) {
				Cfg.AA_mode = SendDlgItemMessage( hGeneral, CTRL_G_AA, CB_GETCURSEL, 0, 0 );
				return TRUE;
			}
			break;
		case CTRL_G_SKPAD:
			if( HIWORD( wp ) == CBN_SELCHANGE ) {
				Cfg.Sketchpad_mode = SendDlgItemMessage( hGeneral, CTRL_G_SKPAD, CB_GETCURSEL, 0, 0 );
				return TRUE;
			}
			break;
		case CTRL_G_MFDTEX:
			if( HIWORD( wp ) == CBN_SELCHANGE ) {
				Cfg.MFD_filter = SendDlgItemMessage( hGeneral, CTRL_G_MFDTEX, CB_GETCURSEL, 0, 0 );
				return TRUE;
			}
			break;
		case CTRL_G_MFDTRF:
			if( HIWORD(wp) == EN_CHANGE ) {
				GetWindowTextA( GetDlgItem( hGeneral, CTRL_G_MFDTRF ), cbuf, 32 );
				sscanf( cbuf, "%f", &transp );
				Cfg.MFD_transparency = (WORD)transp;
				return TRUE;
			}
			break;
		case CTRL_G_THREADS_HELP:
			if( HIWORD( wp ) == BN_CLICKED ) {
				MessageBoxA( hGeneral, "In singlethreaded mode Orbiter waits while D3D11Client perform rendering of a scene and can proceed only after scene was rendered.\nThe 2-threaded mode allows Orbiter thread to perform its calculations on one CPU core, while rendering is being performed on another CPU core. Frequent usage of 2-D drawings can reduce benefit from 2-threaded mode.", "Help", MB_OK );
				return TRUE;
			}
			break;
		case CTRL_G_AA_HELP:
			if( HIWORD( wp ) == BN_CLICKED ) {
				MessageBoxA( hGeneral, "Antialising modes that current GPU supports. CSAA modes available for NVidia cards only.", "Help", MB_OK );
				return TRUE;
			}
			break;
		case CTRL_G_SKPAD_HELP:
			if( HIWORD( wp ) == BN_CLICKED ) {
				MessageBoxA( hGeneral, "GDI only - setting force usage of GDI even for back buffer.\n\nD3D11Pad only - force usage of hardware-accelerated sketchpad for any surface.(except direct GetDC calls).This setting allows maximum performance, but some old MFDs(which can directly use GDI DC) will not work correctly.\n\nD3D11Pad for back buffer only - alows GDI usage only for MFDs.\n\nDebug string, markers and HUD works through D3D11Pad regardless user's choice.", "Help", MB_OK );
				return TRUE;
			}
			break;
		}
	}
	return DefWindowProcA( hwnd, msg, wp, lp );
}

LRESULT VideoTab::VesselProc( HWND hwnd, UINT msg, WPARAM wp, LPARAM lp ) {
	switch( msg ) {
	case WM_COMMAND:
		
		switch( LOWORD( wp ) ) {
		case CTRL_V_MIPMAP:
			if( HIWORD( wp ) == CBN_SELCHANGE ) {
				Cfg.Mesh_Texture_Mip_maps = SendDlgItemMessage( hVessels, CTRL_V_MIPMAP, CB_GETCURSEL, 0, 0 );
				return TRUE;
			}
			break;
		case CTRL_V_MIPMAP_HLP:
			if( HIWORD( wp ) == BN_CLICKED )
				MessageBoxA( hVessels, "Mip maps allows a texture appear better from distance. Full mip map chain usege is recommended.", "Help", MB_OK );
			break;
		case CTRL_V_TEXFILTER:
			if( HIWORD( wp ) == CBN_SELCHANGE ) {
				Cfg.Mesh_Texture_Filter = SendDlgItemMessage( hVessels, CTRL_V_TEXFILTER, CB_GETCURSEL, 0, 0 );
				return TRUE;
			}
			break;
		case CTRL_V_TEXFILTER_HLP:
			if( HIWORD( wp ) == BN_CLICKED )
				MessageBoxA( hVessels, "Texture filtration of vessel textures and normal/bump/specular/emissive maps. Recommended setting - Anisotropic x8 or x16.", "Help", MB_OK );
			break;
		case CTRL_V_NORM:
			if( HIWORD( wp ) == BN_CLICKED ) {
				Cfg.Mesh_Normal_maps = SendDlgItemMessage( hVessels, CTRL_V_NORM, BM_GETCHECK, 0, 0 ) ? 0 : 1;
				SendDlgItemMessage( hVessels, CTRL_V_NORM, BM_SETCHECK, Cfg.Mesh_Normal_maps, 0 );
				return TRUE;
			}
			break;
		case CTRL_V_NORM_HLP:
			if( HIWORD( wp ) == BN_CLICKED )
				MessageBoxA( hVessels, "Normal maps store normal vectors in RGB image. They should be used for creation of bumpy surfaces without addition of vertices.\nSupported formats: DXT1/3/5, R8G8B8, R8G8B8A8 .dds files. Alpha channel not used. ", "Help", MB_OK );
			break;
		case CTRL_V_BUMP:
			if( HIWORD( wp ) == BN_CLICKED ) {
				Cfg.Mesh_Bump_maps = SendDlgItemMessage( hVessels, CTRL_V_BUMP, BM_GETCHECK, 0, 0 ) ? 0 : 1;
				SendDlgItemMessage( hVessels, CTRL_V_BUMP, BM_SETCHECK, Cfg.Mesh_Bump_maps, 0 );
				return TRUE;
			}
			break;
		case CTRL_V_BUMP_HLP:
			if( HIWORD( wp ) == BN_CLICKED )
				MessageBoxA( hVessels, "Bump maps are heightmaps of a surface. Lower(inner) parts are darker, higher(outer) parts are lighter.\nSupported formats: DXT1/3/5, L8, R8G8B8, R8G8B8A8 and other .dds files. Only first color channel is used.", "Help", MB_OK );
			break;
		case CTRL_V_SPEC:
			if( HIWORD( wp ) == BN_CLICKED ) {
				Cfg.Mesh_Specular_maps = SendDlgItemMessage( hVessels, CTRL_V_SPEC, BM_GETCHECK, 0, 0 ) ? 0 : 1;
				SendDlgItemMessage( hVessels, CTRL_V_SPEC, BM_SETCHECK, Cfg.Mesh_Specular_maps, 0 );
				return TRUE;
			}
			break;
		case CTRL_V_SPEC_HLP:
			if( HIWORD( wp ) == BN_CLICKED )
				MessageBoxA( hVessels, "Specular maps store specular color in RGB components and specular power in alpha channel. Specular maps should be used for surfaces that has different specular color and/or specular power.\nSupported formats: DXT5, R8G8B8A8 .dds files. Alpha channel required.", "Help", MB_OK );
			break;
		case CTRL_V_EMIS:
			if( HIWORD( wp ) == BN_CLICKED ) {
				Cfg.Mesh_Emissive_maps = SendDlgItemMessage( hVessels, CTRL_V_EMIS, BM_GETCHECK, 0, 0 ) ? 0 : 1;
				SendDlgItemMessage( hVessels, CTRL_V_EMIS, BM_SETCHECK, Cfg.Mesh_Emissive_maps, 0 );
				return TRUE;
			}
			break;
		case CTRL_V_EMIS_HLP:
			if( HIWORD( wp ) == BN_CLICKED )
				MessageBoxA( hVessels, "Emissive maps store emissive color and should be used for hot or light emitting parts of vessel surface.\nSupported formats: DXT 1/3/5, R8G8B8 and R8G8B8A8 .dds files. DXT1 recommended.", "Help", MB_OK );
			break;
		case CTRL_V_PSLLIGHTS:
			if( HIWORD( wp ) == BN_CLICKED ) {
				Cfg.PStream_LLights = SendDlgItemMessage( hVessels, CTRL_V_PSLLIGHTS, BM_GETCHECK, 0, 0 ) ? 0 : 1;
				SendDlgItemMessage( hVessels, CTRL_V_PSLLIGHTS, BM_SETCHECK, Cfg.PStream_LLights, 0 );
				return TRUE;
			}
			break;
		case CTRL_V_PSLLIGHTS_HLP:
			if( HIWORD( wp ) == BN_CLICKED )
				MessageBoxA( hVessels, "Enables lighting of diffuse particle streams by vessel local lights", "Help", MB_OK );
			break;
		case CTRL_V_BASELLIGHTS:
			if( HIWORD( wp ) == BN_CLICKED ) {
				Cfg.Base_LLights = SendDlgItemMessage( hVessels, CTRL_V_BASELLIGHTS, BM_GETCHECK, 0, 0 ) ? 0 : 1;
				SendDlgItemMessage( hVessels, CTRL_V_BASELLIGHTS, BM_SETCHECK, Cfg.Base_LLights, 0 );
				return TRUE;
			}
			break;
		case CTRL_V_BASELLIGHTS_HLP:
			if( HIWORD( wp ) == BN_CLICKED )
				MessageBoxA( hVessels, "Enables lighting of base tiles and meshes by vessel local lights", "Help", MB_OK );
			break;
		case CTRL_V_TILELLIGHTS:
			if( HIWORD( wp ) == BN_CLICKED ) {
				Cfg.PlanetTile_LLights = SendDlgItemMessage( hVessels, CTRL_V_TILELLIGHTS, BM_GETCHECK, 0, 0 ) ? 0 : 1;
				SendDlgItemMessage( hVessels, CTRL_V_TILELLIGHTS, BM_SETCHECK, Cfg.PlanetTile_LLights, 0 );
				return TRUE;
			}
			break;
		case CTRL_V_TILELLIGHTS_HLP:
			if( HIWORD( wp ) == BN_CLICKED )
				MessageBoxA( hVessels, "Enables lighting of planet tiles by vessel local lights.", "Help", MB_OK );
			break;
		}
	}
	return DefWindowProcA( hwnd, msg, wp, lp );
}

LRESULT VideoTab::PlanetProc( HWND hwnd, UINT msg, WPARAM wp, LPARAM lp ) {
	static char cbuf[32];
	static float lfreq;

	switch( msg ) {
	case WM_COMMAND:
		
		switch( LOWORD( wp ) ) {
		case CTRL_P_TEXFILTER:
			if( HIWORD( wp ) == CBN_SELCHANGE ) {
				Cfg.Planet_Texture_filter = SendDlgItemMessage( hPlanets, CTRL_P_TEXFILTER, CB_GETCURSEL, 0, 0 );
				return TRUE;
			}
			break;
		case CTRL_P_TEXFILTER_HLP:
			if( HIWORD( wp ) == BN_CLICKED )
				MessageBoxA( hPlanets, "Texture filtration mode for planet textures.", "Help", MB_OK );
			break;
		case CTRL_P_LFREQ:
			if( HIWORD(wp) == EN_CHANGE ) {
				GetWindowTextA( GetDlgItem( hPlanets, CTRL_P_LFREQ ), cbuf, 32 );
				sscanf( cbuf, "%f", &lfreq );
				Cfg.Planet_Tile_loading_Freq = (WORD)lfreq;
				return TRUE;
			}
			break;
		}
	}
	return DefWindowProcA( hwnd, msg, wp, lp );
}

void VideoTab::InitConfigWindow() {
	HFONT hFont;
	HWND hw;
	WNDCLASSA wc;

	cfg->LoadConfig();
	cfg->ApplyConfig();

	wc.lpszClassName = "Config";
	wc.lpszMenuName = NULL;
	wc.hInstance = hDLL;
	wc.hCursor = LoadCursor( 0, IDC_ARROW );
	wc.hIcon = LoadIcon( 0, IDI_APPLICATION );
	wc.lpfnWndProc = _ConfigProc;
	wc.cbWndExtra = 0;
	wc.cbClsExtra = 0;
	wc.hbrBackground = CreateSolidBrush( RGB( 245, 245, 245 ) );
	wc.style = CS_HREDRAW | CS_VREDRAW;
	RegisterClassA( &wc );

	hConfig = CreateWindowExA( WS_EX_CLIENTEDGE, "Config", "D3D11Client configuration",
		WS_MINIMIZEBOX | WS_VISIBLE | WS_CAPTION | WS_POPUPWINDOW, 400, 100, 370, 550, hTab, 0, hDLL, NULL );

	//===============================================================

	hw = CreateWindowA( "button", "OK", WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, 110, 483, 115, 30, hConfig, (HMENU)CTRL_OK, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	hw = CreateWindowA( "button", "Cancel", WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, 235, 483, 115, 30, hConfig, (HMENU)CTRL_CANCEL, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	//===============================================================

	hw = CreateWindowA( "button", "General", WS_CHILD | WS_VISIBLE | BS_CHECKBOX | BS_PUSHLIKE , 5, 5, 100, 30, hConfig, (HMENU)CTRL_GENERAL, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	hw = CreateWindowA( "button", "Vessel", WS_CHILD | WS_VISIBLE | BS_CHECKBOX | BS_PUSHLIKE, 5, 40, 100, 30, hConfig, (HMENU)CTRL_VESSELS, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	hw = CreateWindowA( "button", "Planets", WS_CHILD | WS_VISIBLE | BS_CHECKBOX | BS_PUSHLIKE, 5, 75, 100, 30, hConfig, (HMENU)CTRL_PLANETS, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));
	
	//===============================================================	

	InitGeneralWindow();
	InitVesselWindow();
	InitPlanetWindow();

	ShowWindow( hGeneral, true );
	EnableWindow( hGeneral, true );
	SendDlgItemMessage( hConfig, CTRL_GENERAL, BM_SETCHECK, 1, 0 );
	SendDlgItemMessage( hConfig, CTRL_VESSELS, BM_SETCHECK, 0, 0 );
	SendDlgItemMessage( hConfig, CTRL_PLANETS, BM_SETCHECK, 0, 0 );

	memcpy( &Cfg, &cfg->Cfg, sizeof(D3D11CONFIG) );
	
	InitConfig();
}

void VideoTab::InitConfig() {
	char cbuf[32];

	for( UINT j = 0; j < Cfg.AA_count; j++ )
		SendDlgItemMessageA( hGeneral, CTRL_G_AA, CB_ADDSTRING, 0, (LPARAM)cfg->AAModes[j].desc );

	LRESULT res = SendDlgItemMessageA( hGeneral, CTRL_G_THREADS, CB_SETCURSEL, Cfg.Thread_mode, 0 );
	SendDlgItemMessageA( hGeneral, CTRL_G_AA, CB_SETCURSEL, Cfg.AA_mode, 0 );
	SendDlgItemMessageA( hGeneral, CTRL_G_SKPAD, CB_SETCURSEL, Cfg.Sketchpad_mode, 0 );
	SendDlgItemMessageA( hGeneral, CTRL_G_MFDTEX, CB_SETCURSEL, Cfg.MFD_filter, 0 );
	sprintf( cbuf, "%d", Cfg.MFD_transparency );
	SetWindowTextA( GetDlgItem( hGeneral, CTRL_G_MFDTRF ), cbuf );

	SendDlgItemMessageA( hVessels, CTRL_V_MIPMAP, CB_SETCURSEL, Cfg.Mesh_Texture_Mip_maps, 0 );
	SendDlgItemMessageA( hVessels, CTRL_V_TEXFILTER, CB_SETCURSEL, Cfg.Mesh_Texture_Filter, 0 );
	SendDlgItemMessage( hVessels, CTRL_V_NORM, BM_SETCHECK, Cfg.Mesh_Normal_maps, 0 );
	SendDlgItemMessage( hVessels, CTRL_V_BUMP, BM_SETCHECK, Cfg.Mesh_Bump_maps, 0 );
	SendDlgItemMessage( hVessels, CTRL_V_SPEC, BM_SETCHECK, Cfg.Mesh_Specular_maps, 0 );
	SendDlgItemMessage( hVessels, CTRL_V_EMIS, BM_SETCHECK, Cfg.Mesh_Emissive_maps, 0 );
	SendDlgItemMessage( hVessels, CTRL_V_PSLLIGHTS, BM_SETCHECK, Cfg.PStream_LLights, 0 );
	SendDlgItemMessage( hVessels, CTRL_V_BASELLIGHTS, BM_SETCHECK, Cfg.Base_LLights, 0 );
	SendDlgItemMessage( hVessels, CTRL_V_TILELLIGHTS, BM_SETCHECK, Cfg.PlanetTile_LLights, 0 );

	SendDlgItemMessageA( hPlanets, CTRL_P_TEXFILTER, CB_SETCURSEL, Cfg.Planet_Texture_filter, 0 );
	sprintf( cbuf, "%d", Cfg.Planet_Tile_loading_Freq );
	SetWindowTextA( GetDlgItem( hPlanets, CTRL_P_LFREQ ), cbuf );
}

void VideoTab::InitGeneralWindow() {
	WNDCLASSA wc;
	HWND hw;
	HFONT hFont;

	wc.lpszClassName = "General_cfg";
	wc.lpszMenuName = NULL;
	wc.hInstance = hDLL;
	wc.hCursor = LoadCursor( 0, IDC_ARROW );
	wc.hIcon = LoadIcon( 0, IDI_APPLICATION );
	wc.lpfnWndProc = _GeneralProc;
	wc.cbWndExtra = 0;
	wc.cbClsExtra = 0;
	wc.hbrBackground = CreateSolidBrush( RGB( 240, 240, 240 ) );
	wc.style = CS_HREDRAW | CS_VREDRAW;
	RegisterClassA( &wc );

	hGeneral = CreateWindowExA( WS_EX_CLIENTEDGE, "General_cfg", "Planets",
		WS_CHILD | WS_BORDER , 110, 5 , 245, 473, hConfig, 0, hDLL, NULL );

	//===============================================================

	hw = CreateWindowA( "button", "Threading", WS_CHILD | WS_VISIBLE | BS_GROUPBOX, 5, 5, 220, 50, hGeneral, (HMENU)9102, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	hw = CreateWindowA( "combobox", "render type", WS_CHILD | WS_VISIBLE | CBS_DROPDOWNLIST, 10, 27, 177, 40, hGeneral, (HMENU)CTRL_G_THREADS, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	SendDlgItemMessageA( hGeneral, CTRL_G_THREADS, CB_ADDSTRING, 0, (LPARAM)"Single - Threaded" );
//	SendDlgItemMessageA( hGeneral, CTRL_G_THREADS, CB_ADDSTRING, 0, (LPARAM)"Separated rendering thread" );

	hw = CreateWindowA( "button", "?", WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, 190, 27, 30, 20, hGeneral, (HMENU)CTRL_G_THREADS_HELP, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	//===============================================================

	hw = CreateWindowA( "button", "Anti-Aliasing", WS_CHILD | WS_VISIBLE | BS_GROUPBOX, 5, 55, 220, 50, hGeneral, (HMENU)9104, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	hw = CreateWindowA( "combobox", "render type", WS_CHILD | WS_VISIBLE | CBS_DROPDOWNLIST, 10, 77, 177, 40, hGeneral, (HMENU)CTRL_G_AA, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	hw = CreateWindowA( "button", "?", WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, 190, 77, 30, 20, hGeneral, (HMENU)CTRL_G_AA_HELP, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));
		
	//===============================================================

	hw = CreateWindowA( "button", "Sketchpad mode", WS_CHILD | WS_VISIBLE | BS_GROUPBOX, 5, 110, 220, 50, hGeneral, (HMENU)9106, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	hw = CreateWindowA( "combobox", "render type", WS_CHILD | WS_VISIBLE | CBS_DROPDOWNLIST, 10, 132, 177, 40, hGeneral, (HMENU)CTRL_G_SKPAD, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	SendDlgItemMessageA( hGeneral, CTRL_G_SKPAD, CB_ADDSTRING, 0, (LPARAM)"GDI only" );
	SendDlgItemMessageA( hGeneral, CTRL_G_SKPAD, CB_ADDSTRING, 0, (LPARAM)"D3D11Pad for back buffer only" );
	SendDlgItemMessageA( hGeneral, CTRL_G_SKPAD, CB_ADDSTRING, 0, (LPARAM)"D3D11Pad only" );

	hw = CreateWindowA( "button", "?", WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, 190, 132, 30, 20, hGeneral, (HMENU)CTRL_G_SKPAD_HELP, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	//===============================================================

	hw = CreateWindowA( "button", "MFD texture filter", WS_CHILD | WS_VISIBLE | BS_GROUPBOX, 5, 165, 190, 50, hGeneral, (HMENU)9108, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	hw = CreateWindowA( "combobox", "render type", WS_CHILD | WS_VISIBLE | CBS_DROPDOWNLIST, 10, 187, 180, 40, hGeneral, (HMENU)CTRL_G_MFDTEX, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	SendDlgItemMessageA( hGeneral, CTRL_G_MFDTEX, CB_ADDSTRING, 0, (LPARAM)"Point filtration" );
	SendDlgItemMessageA( hGeneral, CTRL_G_MFDTEX, CB_ADDSTRING, 0, (LPARAM)"Linear filtration" );

	hw = CreateWindowA( "button", "MFD transparency (%)", WS_CHILD | WS_VISIBLE | BS_GROUPBOX, 5, 220, 190, 50, hGeneral, (HMENU)9112, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	hw = CreateWindowA( "edit", "90", WS_CHILD | WS_VISIBLE | WS_BORDER | ES_LEFT, 10, 242, 50, 22, hGeneral, (HMENU)CTRL_G_MFDTRF, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));
}

void VideoTab::InitVesselWindow() {
	WNDCLASSA wc;
	HWND hw;;
	HFONT hFont;

	wc.lpszClassName = "Vessel_cfg";
	wc.lpszMenuName = NULL;
	wc.hInstance = hDLL;
	wc.hCursor = LoadCursor( 0, IDC_ARROW );
	wc.hIcon = LoadIcon( 0, IDI_APPLICATION );
	wc.lpfnWndProc = _VesselProc;
	wc.cbWndExtra = 0;
	wc.cbClsExtra = 0;
	wc.hbrBackground = CreateSolidBrush( RGB( 240, 240, 240 ) );
	wc.style = CS_HREDRAW | CS_VREDRAW;
	RegisterClassA( &wc );

	hVessels = CreateWindowExA( WS_EX_CLIENTEDGE, "Vessel_cfg", "Vessels",
		WS_CHILD | WS_BORDER , 110, 5, 245, 473, hConfig, 0, hDLL, NULL );

	hw = CreateWindowA( "button", "General texture settings", WS_CHILD | WS_VISIBLE | BS_GROUPBOX, 5, 5, 230, 120, hVessels, (HMENU)9202, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	//mip mapping
	hw = CreateWindowA( "button", "Mip mapping", WS_CHILD | WS_VISIBLE | BS_GROUPBOX, 10, 20, 220, 50, hVessels, (HMENU)9202, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	hw = CreateWindowA( "combobox", "mipmaps", WS_CHILD | WS_VISIBLE | CBS_DROPDOWNLIST, 15, 42, 177, 40, hVessels, (HMENU)CTRL_V_MIPMAP, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	SendDlgItemMessageA( hVessels, CTRL_V_MIPMAP, CB_ADDSTRING, 0, (LPARAM)"No mip maps" );
	SendDlgItemMessageA( hVessels, CTRL_V_MIPMAP, CB_ADDSTRING, 0, (LPARAM)"4 mip maps" );
	SendDlgItemMessageA( hVessels, CTRL_V_MIPMAP, CB_ADDSTRING, 0, (LPARAM)"Full mip map chain" );

	hw = CreateWindowA( "button", "?", WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, 195, 42, 30, 20, hVessels, (HMENU)CTRL_V_MIPMAP_HLP, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	//filter
	hw = CreateWindowA( "button", "Texture filtration", WS_CHILD | WS_VISIBLE | BS_GROUPBOX, 10, 70, 220, 50, hVessels, (HMENU)9204, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	hw = CreateWindowA( "combobox", "texfilter", WS_CHILD | WS_VISIBLE | CBS_DROPDOWNLIST, 15, 92, 177, 40, hVessels, (HMENU)CTRL_V_TEXFILTER, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	SendDlgItemMessageA( hVessels, CTRL_V_TEXFILTER, CB_ADDSTRING, 0, (LPARAM)"None (point)" );
	SendDlgItemMessageA( hVessels, CTRL_V_TEXFILTER, CB_ADDSTRING, 0, (LPARAM)"Linear" );
	SendDlgItemMessageA( hVessels, CTRL_V_TEXFILTER, CB_ADDSTRING, 0, (LPARAM)"Anisotropic x4" );
	SendDlgItemMessageA( hVessels, CTRL_V_TEXFILTER, CB_ADDSTRING, 0, (LPARAM)"Anisotropic x8" );
	SendDlgItemMessageA( hVessels, CTRL_V_TEXFILTER, CB_ADDSTRING, 0, (LPARAM)"Anisotropic x16" );

	hw = CreateWindowA( "button", "?", WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, 195, 92, 30, 20, hVessels, (HMENU)CTRL_V_TEXFILTER_HLP, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	hw = CreateWindowA( "button", "Extended vessel texture mapping", WS_CHILD | WS_VISIBLE | BS_GROUPBOX, 5, 130, 230, 137, hVessels, (HMENU)9202, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	//normal maps
	hw = CreateWindowA( "button", "Enable normal maps (_norm.dds)", WS_CHILD | WS_VISIBLE | BS_CHECKBOX, 10, 145, 190, 30, hVessels, (HMENU)CTRL_V_NORM, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	hw = CreateWindowA( "button", "?", WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, 200, 150, 30, 20, hVessels, (HMENU)CTRL_V_NORM_HLP, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	//bump maps
	hw = CreateWindowA( "button", "Enable bump maps (_bump.dds)", WS_CHILD | WS_VISIBLE | BS_CHECKBOX, 10, 175, 190, 30, hVessels, (HMENU)CTRL_V_BUMP, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	hw = CreateWindowA( "button", "?", WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, 200, 180, 30, 20, hVessels, (HMENU)CTRL_V_BUMP_HLP, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	//specular maps
	hw = CreateWindowA( "button", "Enable specular maps (_spec.dds)", WS_CHILD | WS_VISIBLE | BS_CHECKBOX, 10, 205, 190, 30, hVessels, (HMENU)CTRL_V_SPEC, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	hw = CreateWindowA( "button", "?", WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, 200, 210, 30, 20, hVessels, (HMENU)CTRL_V_SPEC_HLP, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	//emissive maps
	hw = CreateWindowA( "button", "Enable emissive maps (_ems.dds)", WS_CHILD | WS_VISIBLE | BS_CHECKBOX, 10, 235, 190, 30, hVessels, (HMENU)CTRL_V_EMIS, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	hw = CreateWindowA( "button", "?", WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, 200, 240, 30, 20, hVessels, (HMENU)CTRL_V_EMIS_HLP, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));
/*
	hw = CreateWindowA( "button", "Extended vessel local lights", WS_CHILD | WS_VISIBLE | BS_GROUPBOX, 5, 270, 230, 107, hVessels, (HMENU)9202, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	//particle streams
	hw = CreateWindowA( "button", "Enable particle stream lighting", WS_CHILD | WS_VISIBLE | BS_CHECKBOX, 10, 285, 190, 30, hVessels, (HMENU)CTRL_V_PSLLIGHTS, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	hw = CreateWindowA( "button", "?", WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, 200, 290, 30, 20, hVessels, (HMENU)CTRL_V_PSLLIGHTS_HLP, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	//base lights
	hw = CreateWindowA( "button", "Enable base lighting", WS_CHILD | WS_VISIBLE | BS_CHECKBOX, 10, 315, 190, 30, hVessels, (HMENU)CTRL_V_BASELLIGHTS, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	hw = CreateWindowA( "button", "?", WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, 200, 320, 30, 20, hVessels, (HMENU)CTRL_V_BASELLIGHTS_HLP, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	//planet tile
	hw = CreateWindowA( "button", "Enable planet tile lighting", WS_CHILD | WS_VISIBLE | BS_CHECKBOX, 10, 345, 190, 30, hVessels, (HMENU)CTRL_V_TILELLIGHTS, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	hw = CreateWindowA( "button", "?", WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, 200, 350, 30, 20, hVessels, (HMENU)CTRL_V_TILELLIGHTS_HLP, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));
*/
}

void VideoTab::InitPlanetWindow() {
	WNDCLASSA wc;
	HWND hw;;
	HFONT hFont;

	wc.lpszClassName = "Planet_cfg";
	wc.lpszMenuName = NULL;
	wc.hInstance = hDLL;
	wc.hCursor = LoadCursor( 0, IDC_ARROW );
	wc.hIcon = LoadIcon( 0, IDI_APPLICATION );
	wc.lpfnWndProc = _PlanetsProc;
	wc.cbWndExtra = 0;
	wc.cbClsExtra = 0;
	wc.hbrBackground = CreateSolidBrush( RGB( 240, 240, 240 ) );
	wc.style = CS_HREDRAW | CS_VREDRAW;
	RegisterClassA( &wc );

	hPlanets = CreateWindowExA( WS_EX_CLIENTEDGE, "Planet_cfg", "Planets",
		WS_CHILD | WS_BORDER , 110, 5, 245, 473, hConfig, 0, hDLL, NULL );

	hw = CreateWindowA( "button", "Planet Texture filtration", WS_CHILD | WS_VISIBLE | BS_GROUPBOX, 5, 5, 220, 50, hPlanets, (HMENU)9204, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	hw = CreateWindowA( "combobox", "Ptexfilter", WS_CHILD | WS_VISIBLE | CBS_DROPDOWNLIST, 10, 27, 177, 40, hPlanets, (HMENU)CTRL_P_TEXFILTER, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	SendDlgItemMessageA( hPlanets, CTRL_P_TEXFILTER, CB_ADDSTRING, 0, (LPARAM)"None (point)" );
	SendDlgItemMessageA( hPlanets, CTRL_P_TEXFILTER, CB_ADDSTRING, 0, (LPARAM)"Linear" );
	SendDlgItemMessageA( hPlanets, CTRL_P_TEXFILTER, CB_ADDSTRING, 0, (LPARAM)"Anisotropic x4" );
	SendDlgItemMessageA( hPlanets, CTRL_P_TEXFILTER, CB_ADDSTRING, 0, (LPARAM)"Anisotropic x8" );
	SendDlgItemMessageA( hPlanets, CTRL_P_TEXFILTER, CB_ADDSTRING, 0, (LPARAM)"Anisotropic x16" );

	hw = CreateWindowA( "button", "?", WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, 190, 27, 30, 20, hPlanets, (HMENU)CTRL_P_TEXFILTER_HLP, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	hw = CreateWindowA( "button", "Tile loading frequency (10-200 Hz)", WS_CHILD | WS_VISIBLE | BS_GROUPBOX, 5, 55, 190, 50, hPlanets, (HMENU)9304, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));

	hw = CreateWindowA( "edit", "50", WS_CHILD | WS_VISIBLE | WS_BORDER | ES_LEFT, 10, 77, 50, 22, hPlanets, (HMENU)CTRL_P_LFREQ, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));
/*
	hw = CreateWindowA( "button", "Preload tiles at start", WS_CHILD | WS_VISIBLE | BS_CHECKBOX, 10, 110, 190, 30, hPlanets, (HMENU)CTRL_P_LMODE, hDLL, NULL );
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	SendMessage( hw, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));
*/
}
