module OSDN; module CLI; module Command
  class FrsUpload < Base
    def help
      puts "#{$0} frs_upload [opts] [target_dir]"
      puts "Options:"
      puts "  -n --dry-run               Do noting (use with global -v to inspect)"
      puts "  -p --project=<project>     Target project (numeric id or name)"
      #puts "     --package=<project>     Target package (numeric id)"
      #puts "     --release=<project>     Target release (numeric id)"
      puts "  -v --visibility=<public|private|hidden>"
      puts "                             Default visibility for newly created items"
    end

    def run
      update_token
      opts = GetoptLong.new(
        [ '--dry-run', '-n', GetoptLong::NO_ARGUMENT ],
        [ '--project', '-p', GetoptLong::REQUIRED_ARGUMENT ],
        [ '--release', '-r', GetoptLong::REQUIRED_ARGUMENT ],
        [ '--visibility', '-v', GetoptLong::REQUIRED_ARGUMENT ],
      )
      opts.each do |opt, arg|
        case opt
        when '--project'
          arg.empty? or
            @target_proj = arg
        #when '--release'
        #  arg.empty? or
        #    @target_release = arg
        #when '--package'
        #  arg.empty? or
        #    @target_package = arg
        when '--visibility'
          unless %w(public private hidden).member?(arg)
            logger.fatal "Invalid visibility status: #{arg}"
            exit
          end
          @visibility = arg
        when '--dry-run'
          @dry_run = true
        end
      end

      @target_dir = Pathname.new(ARGV.shift || '.')
      proj_info = api.get_project target_proj # check project existance

      Pathname.glob(@target_dir+'*').each do |pdir|
        unless load_variables(pdir).package_id
          logger.info "Createing new package '#{pdir.basename}'"
          pinfo = api.create_package target_proj, pdir.basename, visibility: @visibility
          update_variables pdir, package_id: pinfo.id
          $stdout.puts "New package '#{pinfo.name}' has been created; #{pinfo.url}"
        end

        Pathname.glob(pdir + '*').each do |rdir|
          vars = load_variables(rdir)
          rinfo = nil
          if vars.release_id
            rinfo = api.get_release target_proj, target_package(rdir), target_release(rdir)
          else vars.release_id
            logger.info "Createing new release '#{rdir.basename}'"
            rinfo = nil
            if api.respond_to? :create_reelase # TODO: remove, just typo...
              rinfo = api.create_reelase target_proj, target_package(rdir), rdir.basename, visibility: @visibility
            else
              rinfo = api.create_release target_proj, target_package(rdir), rdir.basename, visibility: @visibility
            end
            update_variables rdir, release_id: rinfo.id
            $stdout.puts "New release '#{rinfo.name}' has been created; #{rinfo.url}"
          end
          
          Pathname.glob(rdir + '*').each do |file|
            if file.directory?
              logger.error "Skip direcotry #{file}"
              next
            end

            if rinfo.files.find { |f| f.name == file.basename.to_s }
              logger.warn "Skip already uploaded file '#{file}'"
            else
              logger.info "Uploading file #{file} (#{file.size} bytes)"
              # TODO: show progress bar!
              finfo = api.create_release_file target_proj, target_package(rdir), target_release(rdir), file.open, visibility: @visibility
              logger.info "Upload completed."
              $stdout.puts "New file '#{file}' has been uploaded; #{finfo.url}"
            end
          end
        end
      end
    end

    def self.description
      "Upload local file tree and create package/release implicitly."
    end

    private
    def target_proj
      @target_proj and return @target_proj
      vars = load_variables(@target_dir)
      vars.project && !vars.project.empty? and
        return vars.project
      logger.fatal "No target project is specified."
      exit
    end

    def target_package(dir)
      @target_package and return @target_package
      vars = load_variables(dir)
      vars.package_id && !vars.package_id.to_s.empty? and
        return vars.package_id
      logger.fatal "No target package is specified."
      exit
    end

    def target_release(dir)
      @target_release and return @target_release
      vars = load_variables(dir)
      vars.release_id && !vars.release_id.to_s.empty? and
        return vars.release_id
      logger.fatal "No target release is specified."
      exit
    end

    def api
      OSDNClient::ProjectApi.new
    end
  end
end; end; end
