require 'pathname'
require 'fileutils'

module OSDN; module CLI; module Command
  class FrsMkdirs < Base
    def help
      puts "#{$0} frs_mkdirs [opts] [target_dir]"
      puts "Options:"
      puts "  -p --project=<project>     Target project (numeric id or name)"
      #puts "     --package=<package_id>  Target package (numeric id)"
      #puts "     --release=<release_id>  Target release (numeric id)"
    end

    def run
      update_token
      opts = GetoptLong.new(
        [ '--dry-run', '-n', GetoptLong::NO_ARGUMENT ],
        [ '--project', '-p', GetoptLong::REQUIRED_ARGUMENT ],
      )
      opts.each do |opt, arg|
        case opt
        when '--project'
          arg.empty? or
            @target_proj = arg
        end
      end

      proj_info = api.get_project target_proj # check project existance

      target_dir = Pathname.new(ARGV.shift || '.')
      FileUtils.mkdir_p target_dir
      update_variables target_dir, project: target_proj

      logger.debug "Getting Package list..."
      packages = api.list_packages target_proj
      logger.debug "Making each package directory"

      packages.each do |package|
        pname = fsname(package.name)
        if pname != package.name
          logger.warn "Package name '#{package.name}' is not suitable for filesystem, using '#{pname}'."
        end
        logger.info "Making directory for package #{pname}"
        pdir = target_dir + pname
        FileUtils.mkdir_p(pdir)
        update_variables pdir, package_id: package.id
        package.releases.each do |release|
          rname = fsname(release.name)
          if rname != release.name
            logger.warn "Release name '#{release.name}' is not suitable for filesystem, using '#{rname}'."
          end
          logger.info "Making directory for release #{rname}"
          rdir = pdir + rname
          FileUtils.mkdir_p(rdir)
          update_variables rdir, release_id: release.id
        end
      end
    end

    def self.description
      "Make directory tree for current project release"
    end

    private
    def target_proj
      @target_proj and return @target_proj
      vars = load_variables
      vars.project && !vars.project.empty? and
        return vars.project
      logger.fatal "No target project is specified."
      exit
    end

    def api
      OSDNClient::ProjectApi.new
    end

    def fsname(name)
      name = name.to_s.tr('/', '-')
      if name.empty?
        name = '(no-name)'
      end
      name
    end
  end
end; end; end
