require 'osdn/cli/command/frs_base'

module OSDN; module CLI; module Command
  class Package < FrsBase
    def help
      puts "#{$0} package [opts] [list]"
      puts "#{$0} package [opts] create <new-package-name>"
      puts "#{$0} package [opts] update [numeric-package-id] [name]"
      puts "#{$0} package [opts] delete [numeric-package-id]"
      puts "Options:"
      puts "  -f --format=<pretty|json>  Set output format"
      puts "  -p --project=<project>     Target project (numeric id or name)"
      puts "  -v --visibility=<public|private|hidden>"
    end

    def self.description
      "Manipulate frs packages of project"
    end

    def process_options
      opts = GetoptLong.new(
        [ '--format', '-f', GetoptLong::REQUIRED_ARGUMENT ],
        [ '--project', '-p', GetoptLong::REQUIRED_ARGUMENT ],
        [ '--visibility', '-v', GetoptLong::REQUIRED_ARGUMENT ],
      )
      opts.each do |opt, arg|
        case opt
        when '--format'
          arg == 'json' and
            self.format = arg
        when '--project'
          arg.empty? or
            @target_proj = arg
        when '--visibility'
          unless %w(public private hidden).member?(arg)
            logger.fatal "Invalid visibility status: #{arg}"
            exit
          end
          @visibility = arg
        end
      end
    end

    def list
      list = api.list_packages target_proj
      if format == 'json'
        puts list.map{|i| i.to_hash}.to_json
      else
        list.each do |p|
          puts format_package(p)
        end
      end
    end

    def create
      name = ARGV.shift
      if !name
        logger.fatal "Package name is missing."
        help
        return
      end
      p = api.create_package target_proj, name, visibility: @visibility
      logger.info "New package has been created."
      puts format_package(p)
    end

    def update
      _set_package_id
      args = {}
      if ARGV[1].to_s != ""
        args[:name] = ARGV[1]
      end
      if @visibility
        args[:visibility] = @visibility
      end
      logger.debug "Updating package #{target_package} as #{args.inspect}"
      p = api.update_package target_proj, target_package, args
      logger.info "Package #{target_package} has been updated."
      puts format_package(p)
    end

    def delete
      _set_package_id
      p = api.delete_package target_proj, target_package
      logger.info "Package #{target_package} has been deleted."
    end

    def _set_package_id
      return if ARGV[0].to_i == 0
      @target_package = ARGV[0].to_i
    end

  end
end; end; end
