# coding: utf-8
lib = File.expand_path('../lib', __FILE__)
$LOAD_PATH.unshift(lib) unless $LOAD_PATH.include?(lib)
require 'osdn/cli/version'
require 'pathname'

Gem::Specification.new do |spec|
  spec.name          = "osdn-cli"
  spec.version       = OSDN::CLI::VERSION
  spec.authors       = ["OSDN"]
  spec.email         = ["admin@osdn.jp"]
  spec.license       = 'MIT'

  spec.summary       = %q{OSDN Command Line Interface}
  spec.description   = %q{Non-intaractive manipulation tool for OSDN}
  spec.homepage      = "https://osdn.jp/projects/osdn-codes/wiki/CommandLineInterface"

  files = %w(ChangeLog README.md) + (Pathname.glob("exe/**/*") + Pathname.glob("lib/**/*")).reject{|f| f.directory? }.map(&:to_s)
  spec.files         = files.reject { |f| f.match(%r{^(test|spec|features)/}) || f.match(%r{(~|\.bak|\.orig|\.rej)$}) }
  spec.bindir        = "exe"
  spec.executables   = spec.files.grep(%r{^exe/}) { |f| File.basename(f) }
  spec.require_paths = ["lib"]

  spec.add_development_dependency "bundler", "~> 1.11"
  spec.add_development_dependency "rake", "~> 10.0"
  spec.add_development_dependency "rspec", "~> 3.0"

  spec.add_dependency "osdn-client", ">= 0.0.20160304", "< 1.0.0"
  spec.add_dependency "hashie"
end
