# WWW::SourceForge.JP::Wiki
# by hylom
# This code is under GPL.
#

use LWP;
use HTTP::Cookies;
use HTTP::Request::Common;
use HTML::Entities;
use Encode;
use utf8;

package Otp::Attach;

sub new {
    my $class = shift @_;
    my $otp = shift @_;

    my $self = {
	'otp' => $otp,
    };

    return bless $self, $class;
}


sub otp {
    my $self = shift @_;
    return $self->{otp};
}

sub _get_attach_url {
    my $self = shift @_;
    my $sid = shift @_;

	return "http://magazine.sourceforge.jp/fileadmin.pl";
}

# post_attachment( <sid>, <filename1>, <filename2>,... )
sub post_attachment {
    my $self = shift @_;
    my %args = @_;

    my $sid = $args{sid};
    my $file_name = $args{file};

    my $url = $self->_get_attach_url( $sid );
    my $ua = $self->otp->lwp_ua;
    my $req = HTTP::Request::Common::POST $url, Content_Type => 'form-data',
    Content => [ 
				file_content => ["$file_name"],
				description => "",
				op => "addFileForStory",
				sid => $sid,
				Submit => "Submit",
	];

    my $resp = $ua->request( $req );

    if( $resp->is_error ) {
	return 0; #print "upload $file_name: failed.\n";
    } else {
	return 1; #print "upload $file_name: succeed.\n";
    }
}

1;
