#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os, sys
import otptools
import getpass
import codecs

sys.stdout = codecs.getwriter('utf_8')(sys.stdout)

usage = sys.argv[0] + " start end <output_file>"
output_encoding = "utf_8"
output_encoding = "cp932"
try:
	start = sys.argv[1]
	end = sys.argv[2]
	file = sys.argv[3]
except IndexError:
	uname = ""
	sys.exit(usage)

if (not start.isdigit()) or (not start.isdigit()):
	sys.exit(usage)

output_file = codecs.open(file, "w", output_encoding)

uname = ""

otp = otptools.otptools("./cookies.txt", uname)
try:
	otp.load_cookie()
except IOError:
	sys.stderr.write("cannot use cookie file. create.\n")

	if otp.get_cookie() == "":
		if uname == "":
			try:
				uname = raw_input("user: ")
			except KeyboardInterrupt:
				sys.exit("\nabort.")
		try:
			passwd = getpass.getpass("login password:")
		except KeyboardInterrupt:
			sys.exit("\nabort.")
		if otp.login(uname, passwd) != 1:
			sys.exit("login error!")

otp.save_cookie()
story_infos = {}
start_index = int(start)
max_index = int(end)

sys.stderr.write( "retrieving lists..." )

for index in range(start_index, max_index, 40):
	html = otp.get_list(index)
	story_infos = otp.parse_list( html, story_infos )

sys.stderr.write( "sorting..." )
sort_keys = story_infos.keys()
sort_keys.sort(lambda x,y: cmp(story_infos[y], story_infos[x]))

sys.stderr.write( "retrieving tags..." )
for url in sort_keys:
	tags = otp.get_tags( "http:" + url )

	story_infos[url]["tags"] = unicode( "|".join(tags), "utf_8" )
	sys.stderr.write(".")

for url in sort_keys:
	for item in story_infos[url]:
		str = story_infos[url][item]
		output_file.write("%(url)s,%(title)s,%(editor)s,%(page_views)s,%(comments)s,%(datetime)s,%(tags)s" % story_infos[url] + "\n")

output_file.close()
sys.stderr.write( "done.\n" )
