#!/usr/bin/python
# -*- coding: utf-8 -*-

import re
import os.path
import sys
import codecs

fh_in  = codecs.getreader('utf_8')(sys.stdin)
fh_out = codecs.getwriter('utf_8')(sys.stdout)
sys.stdout = codecs.getwriter('utf_8')(sys.stdout)

rex1 = re.compile(ur"^☆図([0-9]+)\s+")
rex2 = re.compile(ur"\*図([0-9]+)")
rex3 = re.compile(ur"\*図([0-9]+)[〜～]([0-9]+)")
rex4 = re.compile(ur"\*図([0-9]+)、([0-9]+)")

counter_ref = 1
counter_fig = 1
for l in fh_in:
    m1 = rex1.match(l)
    m2 = rex2.search(l)
    m3 = rex3.search(l)
    m4 = rex4.search(l)

    if m1:
        l = rex1.sub(ur"☆図%d " % (counter_ref,), l)
        counter_ref += 1;
    elif m3:
        ref1 = int(m3.group(1))
        ref2 = int(m3.group(2))
        l = rex3.sub(ur"*図%d～%d" % (counter_fig, counter_fig+ref2-ref1),  l)
        counter_fig += ref2 - ref1 + 1
    elif m4:
        ref1 = int(m4.group(1))
        ref2 = int(m4.group(2))
        l = rex4.sub(ur"*図%d、%d" % (counter_fig, counter_fig+ref2-ref1),  l)
        counter_fig += ref2 - ref1 + 1
    elif m2:
        l = rex2.sub(ur"*図%d" % (counter_fig,), l)
        counter_fig += 1;
    fh_out.write(l)


