# deterfile.py
"""deterfile.py - determine file type"""

import os
import os.path
import re
import getjpggeom

_file_cmd = "file %s"

def file(path):
    """
    determine given file's type.
    This function returns strings.

    @param path: filepath you want to determine
    @type path: string
    """
    if not os.path.isfile(path):
        return ("file not exist.",)

    cmd = _file_cmd % path
    escaped_path = path.replace("\\", "\\\\");
    stdout = os.popen(cmd, "r")
    results = []
    for line in stdout:
        if re.search(r"^%s:" % escaped_path, line):
            line = re.sub(r"^%s:\s*" % escaped_path, "", line)
        tpl = line.strip().split(",")
        results.extend([x.strip() for x in tpl])
    stdout.close()
    return results

#### test code
# import sys

# tgt = sys.argv[1]
# r = file(tgt)
# for item in r:
#     print item
