#!/usr/bin/perl
# SourceForge.JP Wiki manipulator
# by hylom
# This code is under GPL.
#

use warnings;
use strict;

use lib '/Users/hylom/otptools';

use utf8;
use open IO => ':utf8';
use open ':std';

use Getopt::Std;
use SourceForgeJP;
use IO::File;
use Term::Prompt;
use URI::Escape;
use Encode;
use File::Temp;
use Path::Class;

my $usage = <<EOD;
s2wattach.pl <file>
EOD

my $filename= shift @ARGV;
unless( $filename ) {
    print $usage;
    exit;
}

my $project = "test11";
my $filepath = file($filename);
my $parent_dir = $filepath->parent();

my $txtpath = $parent_dir->file("wiki.txt");
my $pagename = get_pagename($txtpath, $project);

my $sf = WWW::SourceForgeJP->new();
my $ret = $sf->Wiki->post_attachment( project => $project,
				      page => $pagename,
				      file => $filepath );
if( $ret ) {
    print "$filepath: upload succeed.\n";
} else {
    print "$filepath: upload failed.\n";
}

sub get_pagename {
    my $fullpath = shift @_;

    my $fh = $fullpath->open("r");
    if( ! $fh ) {
	print STDERR "can't open: $fullpath: $!";
	return
    }
    my $filename = <$fh>;
    $fh->close();
    chomp $filename;
    return $filename;
}
