#!/usr/bin/perl
# SourceForge.JP Wiki manipulator
# by hylom
# This code is under GPL.
#

use warnings;
use strict;

use lib '/Users/hylom/otptools';

use utf8;
use open IO => ':utf8';
use open ':std';

use Getopt::Std;
use SourceForgeJP;
use IO::File;
use Term::Prompt;
use URI::Escape;
use Encode;
use File::Temp;
use Path::Class;

my $usage = <<EOD;
s2wupload.pl <project> <pagename> <file>
EOD

if (@ARGV < 3) {
    print $usage;
    exit;
}

my $project= shift @ARGV;
my $pagename= shift @ARGV;
my $filename= shift @ARGV;

my $filepath = file($filename);
my $parent_dir = $filepath->parent();
upload_text($project, $pagename, $filepath);

sub upload_attachments {
    my $path = shift @_;
    my $project = shift @_;
    my $page = shift @_;

    my $dh = $path->open();
    while( my $file = $dh->read() ) {
	my $file = $path->file($file); # get Path::Class::File object.

	if( ! -e $file ) {
	    die "$file is not exist.\n";
	}
	my $fname = $file->stringify();
	if( not $fname =~ m/\.(jpg|JPG|png|PNG|gif|GIF)$/ ) {
	    next;
	}
	print STDERR "uploading:\n";
	print $file, "\n";
	my $sf = WWW::SourceForgeJP->new();
	my $ret = $sf->Wiki->post_attachment( project => $project,
					      page => $page,
					      file => $fname );

	if( $ret ) {
	    print "$file: upload succeed.\n";
	} else {
	    print "$file: upload failed.\n";
	}

    }
}

sub upload_text {
    my $project = shift @_;
    my $pagename = shift @_;
    my $fullpath = shift @_;

    my $fh = $fullpath->open("r");
    if( ! $fh ) {
	print STDERR "can't open: $fullpath: $!";
	return
    }
#    my $filename = <$fh>;
#    chomp $filename;
#    my $title = <$fh>;
#    chomp $title;
    my $title = "";
    my $body = do { local( $/ ); <$fh> };
    close $fh;

    print STDERR "uploading:\n";
    print $fullpath, "\n";

    my $sf = WWW::SourceForgeJP->new();
    $sf->Wiki->edit_page( project => $project,
			  page => $pagename,
			  text => $body,
			  title => $title,
			  comment => "" );

    return $filename;
}
