#!/usr/bin/perl
# SourceForge.JP Wiki manipulator
# by hylom
# This code is under GPL.
#

use warnings;
use strict;

use lib '/Users/hylom/otptools';

use utf8;
use open IO => ':utf8';
use open ':std';

use Getopt::Std;
use SourceForgeJP;
use IO::File;
use Term::Prompt;
use URI::Escape;
use Encode;
use File::Temp;
use Path::Class;

my $usage = <<EOD;
upload.pl <project> <upload_list>
EOD

sub main {
    if (@_ < 2) {
	print $usage;
	exit;
    }

    my $project = shift @_;
    my $listname = shift @_;

    my $f_list = new IO::File($listname, "r");

    while(my $line = <$f_list>) {
	my @spl = split(/\s+/, $line);
	my $fname = $spl[0];
	my $pagename = uri_escape($spl[1]);
	printf STDERR "upload $fname to $project - $pagename \n";
	upload_text($project, $pagename, $fname);
    }
}

sub upload_attachments {
    my $path = shift @_;
    my $project = shift @_;
    my $page = shift @_;

    my $dh = $path->open();
    while( my $file = $dh->read() ) {
	my $file = $path->file($file); # get Path::Class::File object.

	if( ! -e $file ) {
	    die "$file is not exist.\n";
	}
	my $fname = $file->stringify();
	if( not $fname =~ m/\.(jpg|JPG|png|PNG|gif|GIF)$/ ) {
	    next;
	}
	print STDERR "uploading:\n";
	print $file, "\n";
	my $sf = WWW::SourceForgeJP->new();
	my $ret = $sf->Wiki->post_attachment( project => $project,
					      page => $page,
					      file => $fname );

	if( $ret ) {
	    print "$file: upload succeed.\n";
	} else {
	    print "$file: upload failed.\n";
	}

    }
}

sub upload_text {
    my $project = shift @_;
    my $pagename = shift @_;
    my $fname = shift @_;

    my $fh = new IO::File($fname, "r");
    if( ! $fh ) {
	print STDERR "can't open: $fname: $!";
	return
    }
#    my $filename = <$fh>;
#    chomp $filename;
#    my $title = <$fh>;
#    chomp $title;
    my $title = "";
    my $body = do { local( $/ ); <$fh> };
    close $fh;

    print "$project - $pagename\n";

    my $sf = WWW::SourceForgeJP->new();
    $sf->Wiki->edit_page( project => $project,
			  page => $pagename,
			  text => $body,
			  title => $title,
			  comment => "" );

    return $pagename;
}

main(@ARGV)
