#!/usr/bin/env python
#
"""htproc.py - HTML Processor"""

import sys
from BeautifulSoup import BeautifulSoup

from rules import rules

usage = """%s <src> <dest>""" % sys.argv[0]

try:
    src = sys.argv[1]
    dest = sys.argv[2]
except IndexError:
    sys.exit(usage)

f_src = open(src, "r")
f_dest = open(dest, "w")

html = f_src.read()
bsp = BeautifulSoup(html)

for tag in rules:
    for result in bsp.findAll(tag):
        if rules[tag].has_key("begin"):
            result.insert(0, rules[tag]["begin"])
        if rules[tag].has_key("pre"):
            rawtag = result.prettify()
            if rules[tag].has_key("post"):
                rawtag = rules[tag]["pre"] + rawtag + rules[tag]["post"]
            else:
                rawtag = rules[tag]["pre"] + rawtag
            result.replaceWith(rawtag)

        elif rules[tag].has_key("pre"):
            rawtag = result.prettify() + rules[tag]["post"]
            result.replaceWith(rawtag)

#f_dest.write(bsp.prettify())
f_dest.write(bsp.renderContents())

f_src.close()
f_dest.close()

