#!/usr/bin/python

import re
import os.path
import sys
import shutil

USAGE = '%s <from> <dest>' % os.path.basename(sys.argv[0])
if len(sys.argv) < 3:
    sys.exit(USAGE)

def do_copy(frm, dst):
    shutil.copy(frm, dst)

def main():    
    fh_in = open("txt.txt", "r")
    #fh_out = open("mv.sh", "w")
    dir_from = sys.argv[1]
    dir_dest = sys.argv[2]
    rex_img1 = re.compile(r"^<(.*),\s*(.*)>\s*")
    rex_img2 = re.compile(r"^<(.*)>\s*")


    imgs = []
    for l in fh_in:
        m1 = rex_img1.match(l)
        m2 = rex_img2.match(l)

        if m1:
            imgs.append(m1.group(1))
            imgs.append(m1.group(2))
        elif m2:
            imgs.append(m2.group(1))

    for f in imgs:
        target = os.path.join(dir_from, f)
        dest = os.path.join(dir_dest, f)
        if os.path.exists(dest):
            print "%s is already exists. skip." % dest
        elif not os.path.exists(target):
            print "%s is not exists." % target
        else:
            #print "mv %s/%s %s/" % (dir_from, f, dir_dest)
            print "copy %s to %s/" % (target, dir_dest)
            do_copy(target, dir_dest)
            

if __name__ == '__main__':
    main()
