#!/usr/bin/perl
#Copyright (c) 2008, hylom.
#All rights reserved.
#
#Redistribution and use in source and binary forms, with or without modification, are #permitted provided that the following conditions are met:
#
#    * Redistributions of source code must retain the above copyright notice, this list of #conditions and the following disclaimer.
#    * Redistributions in binary form must reproduce the above copyright notice, this list #of conditions and the following disclaimer in the documentation and/or other materials #provided with the distribution.
#    * Neither the name of the <ORGANIZATION> nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
#
#THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

use strict;
use warnings;
use utf8;

use open ":utf8";
use open ":std";

use IO::File;

my $filename = shift @ARGV;

if( ! $filename ) {
  die "markup.pl hashfile";
}

my $ref_hashlist = make_hashlist( $filename );

while( my $l = <> ) {
  
  chomp $l;
  $l =~ s/&/&amp;/g;
  $l =~ s/</&lt;/g;
  $l =~ s/>/&gt;/g;
  $l =~ s/★(表[0-9～]+)/<b>$1<\/b>/g;
  $l =~ s/★(図[0-9～]+)/<b>$1<\/b>/g;
  $l =~ s/★(リスト[0-9～]+)/<b>$1<\/b>/g;
  while( $l =~ m/★\[(\S*) (.*?)\]/ ) {
    my $url = $1;
    my $text = $2;
    $url =~ s/&amp;/&/g;
    $l =~ s/★\[(\S*) (.*?)\]/<a href="$url">$text<\/a>/;
  }
  $l =~ s/([^"])(http:\/\/[A-Za-z0-9.\/%-]*)([^"])/$1<a href="$2">$2<\/a>$3/g;

    #head-of-line rules
  if( $l =~ m/^☆{{{$/ ) {
    inline($l);
    next;
  }
  elsif( $l =~ m/^☆comment\s*{{{$/ ) {
    comment($l);
    next;
  }
  elsif( $l =~ m/^・/ ) {
    ulist($l);
    next;
  }
  elsif( $l =~ m/^☆begin-column:/ ) {
    begin_column($l);
    next;
  }
  elsif( $l =~ m/^☆end-column/ ) {
    end_column($l);
    next;
  }
  elsif( $l =~ m/^☆space$/ ) {
    space($l);
    next;
  }
  elsif( $l =~ m/^●(.*)$/ ) {
    $l = "<h4>$1</h4>\n";
    print $l;
    next;
  }
  elsif( $l =~ m/^○(.*)$/ ) {
    $l = "<b>○$1</b>\n";
    print $l;
    next;
  }
  elsif( $l =~ m/^☆----$/ ) {
    $l =~ s/☆----/<hr>/g;
    print $l, "\n";
    next;
  }
  elsif( $l =~ m/^☆\+---$/ ) {
      code($l);
    next;
  }
  elsif( $l =~ m/^☆表/ ) {
    table($l);
    next;
  }
  elsif( $l =~ m/^☆図/ ) {
    fig($l, $ref_hashlist);
    next;
  }
  elsif( $l =~ m/^☆リスト/ ) {
    list($l);
    next;
  }


  if( $l =~ m/^　/ ) {
    $l = "<p>$l</p>";
  }
  print $l, "\n";
}

sub ulist {
    my $l = shift @_;

    print "<ul>\n";
    while( $l =~ m/^・/ ) {
      $l =~ s/^・(.*)$/<li>$1<\/li>/;
      print "$l\n";
      $l = <>;
      chomp $l;
    }
    print "</ul>\n\n";
}

sub begin_column {
    my $l = shift @_;

    my $title = "";
    if( $l =~ m/^☆begin-column:(.*)$/ ) {
	$title = $1;
    }
    my $html = << "EOL";
<table bgcolor="#DDDDDD" border="0" cellpadding="6" width="95%">
<tr>
<th>$title</th>
</tr>
<tr>
<td>
<span style="font-size: 85%;;">
EOL

    print $html;
}

sub end_column {
    my $l = shift @_;
    my $html = << "EOL";
</span>
</td>
</tr>
</table>
EOL
    print $html;
}

sub list {
    my $l = shift @_;
    my $cap = "";

    if( $l =~ m/^☆(リスト.*)$/ ) {
      $cap = $1;
    }

    print "<p><b>$cap</b></p>\n";
    print list_start( $cap );
    while( $l = <> ) {
      chomp $l;
      $l =~ s/&/&amp;/g;
      $l =~ s/</&lt;/g;
      $l =~ s/>/&gt;/g;

      if( $l =~ m/^----$/ ) {
	last;
      }
      print $l, "\n";
    }
    print list_end();
}

sub code {
    my $l = shift @_;
    my $cap = "";

    print list_start();
    while( $l = <> ) {
      chomp $l;
      $l =~ s/&/&amp;/g;
      $l =~ s/</&lt;/g;
      $l =~ s/>/&gt;/g;

      if( $l =~ m/^[+-]---$/ ) {
	last;
      }
      print $l, "\n";
    }
    print list_end();
}

sub list_start {
  return "<pre>\n";
}

sub list_end {
  return "</pre>\n";
}

sub inline {
  my $l = shift @_;

  while( $l = <> ) {
    chomp $l;
    if( $l =~ m/^☆}}}$/ ) {
      last;
    }
    print "$l\n";
  }
}

sub comment {
  my $l = shift @_;

  while( $l = <> ) {
    chomp $l;
    if( $l =~ m/^☆}}}$/ ) {
      last;
    }
  }
}
sub space {
  my $l = shift @_;
  print "<br><br>\n";
}

sub fig {
  my $l = shift @_;
  my $ref_filehash = shift @_;
  my $cap = "";

  if( $l =~ m/^☆(図.*)$/ ) {
    $cap = $1;
  }
  print fig_start();

  $l = <>;
  chomp $l;
  my $hash;
  my $hash_s;
  if( $l =~ m/<([^,]*?)>/ ) {
    $hash = $ref_filehash->{$1};
    $hash_s = $ref_filehash->{$1};
  } elsif ( $l =~ m/<(.*?),\s*(.*?)>/ ) {
    $hash = $ref_filehash->{$1};
    $hash_s = $ref_filehash->{$2};
  }
  my $html = << "EOL";
<a href="/blob.pl?id=$hash">
<slash type="image" id="$hash_s" title="$cap">
</a>
EOL
  print $html;
  print fig_end( $cap );
}


sub fig_start {
  my $cap = shift @_;

  my $fig_head = << "EOL";
<table align="center" border="0" cellpadding="0" cellspacing="0">
<tr> <td valign="top">
EOL
  return $fig_head;
}


sub fig_end {
  my $cap = shift @_;

  my $fig_end = <<"EOL";
</td> </tr>
<tr> <td>
<span style="font-size: 80%; font-weight: bold;">
$cap
</span>
</td> </tr>
</table>

EOL
  return $fig_end;
}

sub table {
    my $l = shift @_;
    my $cap = "";

    if( $l =~ m/^☆(表.*)$/ ) {
      $cap = $1;
    }
    print table_start( $cap );
    while( $l = <> ) {
      chomp $l;
      if( $l =~ m/^\s*$/ ) {
	last;
      }
      if( $l =~ m/^〓/ ) {
	$l =~ s/^〓//;
	$l = "<tr><th>$l</th></tr>\n";
	$l =~ s/\t/<\/th><th>/g;
	print $l;
      } else {
	$l = "<tr><td>$l</td></tr>\n";
	$l =~ s/\t/<\/td><td>/g;
        $l =~ s/<td><\/td>/<td> <\/td>/g;
	print $l;
      }
    }
    return table_end();
}

sub table_start {
    my $cap = shift @_;
    my $table_head = << "EOL";
<table align="center" border="1" width="90%">
<caption><b>$cap</b></caption>
EOL

    return $table_head;
}

sub table_end {
  print "</table>\n\n";
}

sub make_hashlist {
  my $file = shift @_;
  my $ref_hashlist;

  if( $file ) {
    my $fh = IO::File->new( "$file", "<" );
    if( $fh ) {
      while( my $l = <$fh> ) {
	chomp $l;
	my ($hash,$imgfilename ) = split( "\t", $l );
	$ref_hashlist->{$imgfilename} = $hash;
      }
    }
  }

  return $ref_hashlist;
}
