#!/usr/bin/env python
# -*- coding: utf-8 -*-
 
import sys
import os
import os.path
import re
import codecs
import hashlib
import dircache

sys.stdin = codecs.getreader('utf_8')(sys.stdin)
sys.stdout = codecs.getwriter('utf_8')(sys.stdout)


usage = "%s directory1 [directory2 ...]" % sys.argv[0]

if len(sys.argv) < 2:
    sys.exit(usage)

for index in range(1, len(sys.argv)):
    dir = sys.argv[index]
    if not os.path.isdir(dir):
        print >> sys.stderr, "%s is not a directory. skip.\n" % dir
        continue

    for target in dircache.listdir(dir):
        tpath = os.path.join(dir, target)
        if not os.path.isfile(tpath):
            print >> sys.stderr, "%s is not a file. skip.\n" % tpath
            continue

        f = open( tpath, "rb")
        buf = f.read()
        f.close()
        m = hashlib.md5()
        m.update(buf)
        print m.hexdigest() + "\t" + target



