#!/bin/env python
# -*- encoding: utf-8 -*-
#
# otp_imgswap.py : otp image tag swapper
#

import sys
import codecs
import re
import os.path
import hashlib

usage = """usage: %s <target file> <output_file>""" % (os.path.basename(sys.argv[0]),)

rex_fig_ref = re.compile(ur"""\*図{([A-Za-z0-9_]+)}""")
rex_fig_def = re.compile(ur"""^☆図{([A-Za-z0-9_]+)}""")
rex_table_ref = re.compile(ur"""\*表{([A-Za-z0-9_]+)}""")
rex_table_def = re.compile(ur"""^☆表{([A-Za-z0-9_]+)}""")
rex_list_ref = re.compile(ur"""\*リスト{([A-Za-z0-9_]+)}""")
rex_list_def = re.compile(ur"""^☆リスト{([A-Za-z0-9_]+)}""")

try:
    in_f = codecs.open(sys.argv[1], "r", "utf_8" )
    out_f = codecs.open(sys.argv[2], "w", "utf_8" )
except IndexError:
    sys.exit(usage)

fig_count = 0
table_count = 0
list_count = 0
dict_fig = {}
dict_table = {}
dict_list = {}
# 1st scan
for line in in_f:
    # figure
    match = rex_fig_def.search(line)
    if match:
        id = match.group(1)
        fig_count = fig_count + 1
        dict_fig[id] = fig_count
    # table
    match = rex_table_def.search(line)
    if match:
        id = match.group(1)
        table_count = table_count + 1
        dict_table[id] = table_count
    # list
    match = rex_list_def.search(line)
    if match:
        id = match.group(1)
        list_count = list_count + 1
        dict_list[id] = list_count
in_f.close()

#create replace list
replace_keys = []
for item in dict_table:
    key = u"*表{%s}" % (item,)
    val = u"*表%d" % dict_table[item]
    replace_keys.append((key, val))
    key = u"☆表{%s}" % (item,)
    val = u"☆表%d" % dict_table[item]
    replace_keys.append((key, val))

for item in dict_list:
    key = u"*リスト{%s}" % (item,)
    val = u"*リスト%d" % dict_list[item]
    replace_keys.append((key, val))
    key = u"☆リスト{%s}" % (item,)
    val = u"☆リスト%d" % dict_list[item]
    replace_keys.append((key, val))

for item in dict_fig:
    key = u"*図{%s}" % (item,)
    val = u"*図%d" % dict_fig[item]
    replace_keys.append((key, val))
    key = u"☆図{%s}" % (item,)
    val = u"☆図%d" % dict_fig[item]
    replace_keys.append((key, val))


# 2nd scan
in_f = codecs.open(sys.argv[1], "r", "utf_8" )
for line in in_f:
    for (key, val) in replace_keys:
        line = line.replace(key, val)

    if rex_fig_ref.search(line):
       match = rex_fig_ref.search(line)
       for group in match.groups():
           print "fig %s isn't defined." % (group,)
    if rex_list_ref.search(line):
       match = rex_list_ref.search(line)
       for group in match.groups():
           print "list %s isn't defined." % (group,)
    if rex_table_ref.search(line):
       match = rex_table_ref.search(line)
       for group in match.groups():
           print "table %s isn't defined." % (group,)

    if (re.search(ur"""^☆include<(.*)>$""", line)):
        fn = re.search(ur"""^☆include<(.*)>$""", line).group(1)
        enc = "utf_8"
        if re.search(r":.*$", fn):
            enc = re.search(r":(.*)$", fn).group(1)
            fn = re.search(r"^(.*):", fn).group(1)
        if os.path.isfile(fn):
            fo = codecs.open(fn, "r", enc )
            content = fo.read()
            print >> out_f, content
            fo.close()
        else:
            print "include: not found: %s" % fn
        continue

    print >> out_f, line,

print "fig: %d, table: %d, list:%d." % (fig_count, table_count, list_count)
