#!/usr/bin/python
# -*- coding: utf-8 -*-
# otpuploader.py
"""otpuploader.py - OpenTechPress Attachment Uploader"""

from poster.encode import multipart_encode
from poster.streaminghttp import register_openers
import urllib
import urllib2
import cookielib

class OtpUploader(object):
    "OpenTechPress Attachment Uploader"
    def __init__(self):
        self.set_attach_url()

    def set_attach_url(self, url=""):
        if url == "":
            url = "http://magazine.sourceforge.jp/fileadmin.pl"
        self._attach_url = url

    def login(self, username, passwd):
        c = cookielib.CookieJar()
        p = urllib2.HTTPCookieProcessor(c)
        opener = urllib2.build_opener(p)

        login_url = "http://magazine.sourceforge.jp/login.pl"
        params = urllib.urlencode({
            "op": "userlogin",
            "unickname": username,
            "upasswd": passwd,
            "userlogin": u"ログイン".encode("utf-8")
            })
        req = opener.open(login_url, params)
        self._cookie = c

    def post_attachment(self, sid, filename):
        params = {
            "file_content": open(filename, "rb"),
            "description": "",
            "op": "addFileForStory",
            "sid": sid,
            "Submit": "Submit"
            }
        opener = register_openers()
        opener.add_handler(urllib2.HTTPCookieProcessor(self._cookie))

        (datagen, headers) = multipart_encode(params)
        request = urllib2.Request(self._attach_url, datagen, headers)
        res = opener.open(request)
        #res = urllib2.urlopen(request)
        #print res.read()

if __name__ == "__main__":
    import getpass
    import getopt
    import sys

    (opts, args) = getopt.getopt(sys.argv[1:], "u:")
    opt_dict = dict(opts)
    print opt_dict
    print args

    if not "-u" in opt_dict:
        uname = raw_input("Username: ")
    else:
        uname = opt_dict["-u"]

    if len(args) < 2:
        sys.exit("usage: cmd sid <filename>")
    sid = args.pop(0)

    passwd = getpass.getpass()
    u = OtpUploader()
    u.login(uname, passwd)
    print "cookie: ", u._cookie

    for f in args:
        print "post %s to sid %s" % (f, sid)
        u.post_attachment(sid, f)

