#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
otptools base module - retain session/login info
"""

OTP_LOGIN_URL = "http://slashdot.jp/login.pl"
OTP_LOGIN_HOST = "slashdot.jp"
OTP_LOGIN_PATH = "/login.pl"

OTP_LOGIN_PARAM = {
    "op":"userlogin",
    "unickname":"",
    "returnto":"http://slashdot.jp",
    "upasswd":"",
#    "login_temp":0,
    "userlogin":"ログイン",
    }

OTP_LIST_PATH = "/admin.pl"

BROWSER = "Mozilla/5.0 (Windows; U; Windows NT 6.0; ja; rv:1.9.0.7) Gecko/2009021910 Firefox/3.0.7 (.NET CLR 3.5.30729) "

import sys
import os
import copy
import urllib, urllib2
import httplib

class otptools(object):
    """
    Open Tech Press management library core module.
    """

    def __init__(self, path_cookie, login_name="", login_password=""):
        """
        @param path_cookie: path of file which cookie's information stored.
        @type  path_cookie: stinrg

        @param login_name: OTP's login name for use.
        @type  login_name: string

        @param login_password: OTP's login password.
        @type  login_password: string
        """
        self.path_cookie = path_cookie
        self.unickname = login_name
        self.upasswd = login_password
        self.cookie = ""

    def login(self):
		"""
		login to OTP.
		"""
        login_param = copy.deepcopy(OTP_LOGIN_PARAM)
        login_param["unickname"] = self.unickname
        login_param["upasswd"] = self.upasswd

        for item in login_param:
            print "%s > %s" % (item, login_param[item])

        encoded_data = urllib.urlencode(login_param)
        print encoded_data

        headers = {
            "User-Agent": BROWSER,
            "Content-type": "application/x-www-form-urlencoded",
            "Accept": "text/plain",
            }

#        obj = urllib.urlopen(OTP_LOGIN_URL, encoded_data)
#        print obj.info()

        obj = httplib.HTTPConnection(OTP_LOGIN_HOST)
        obj.request("POST", OTP_LOGIN_PATH, encoded_data, headers)
        resp = obj.getresponse()
        headers = resp.getheaders()

        for item in headers:
            print item

#        for header in headers:
#            if header[0] == "set-cookie":
#                str_cookie = header[1]
#                break
#        else:
#            return -1
#
#        self.cookie = str_cookie
#        return 1

    def save_cookie(self):
        file_obj = open(self.path_cookie, "w")
        file_obj.write(self.cookie)
        file_obj.close()

    def load_cookie(self):
		"""
		load session cookie from file.
		"""
        file_obj = open(self.path_cookie, "r")
        self.cookie = file_obj.readline()
        file_obj.close()

    def get_list(self):
		"""
		Access admin.pl and retrieve stories list.
		"""
        headers = {
            "User-Agent": BROWSER,
            "Content-type": "application/x-www-form-urlencoded",
            "Accept": "text/plain",
            "Cookie": self.cookie,
            }
        obj = httplib.HTTPConnection(OTP_LOGIN_HOST)
        obj.request("POST", OTP_LIST_PATH, "", headers)
        resp = obj.getresponse()
        headers = resp.getheaders()

        return resp.read()

        
