#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""Test suite for spyder.py."""

import sys
import os.path
import html2sfjpwiki
import re 

target = sys.argv[1]
fh = open(target, "r")
html = fh.read()
fh.close()

dir = os.path.dirname(target)
output = os.path.join(dir, "wiki.txt")

rex = re.compile(r"<\s*script[^>]*?>.*?</script>", re.S)
rex2 = re.compile(r"<\s*noscript[^>]*?>.*?</noscript>", re.S)
tmp = rex.sub("", html)
html_r = rex2.sub("", tmp)

c = html2sfjpwiki.Html2SfjpWiki()
r = c.parse(html_r, "article-body")

fh = open(output, "w")
fh.write(c.title + "\n\n")
fh.write(r)
fh.close()

#print r
