#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""make navigation list"""

import dircache
import sys
import os.path
import urllib

USAGE = "%s <converted_dir>" % sys.argv[0]
try:
    dir = sys.argv[1]
except IndexError:
    sys.exit(USAGE)

if not os.path.isdir(dir):
    sys.exit(USAGE)

for d in dircache.listdir(dir):
    if d[0] == ".":
        continue
    fn = os.path.join(dir, d, "wiki.txt")
    if not os.path.isfile(fn):
        continue
    f = open(fn, "r")
    wikiname = urllib.unquote(f.readline().strip())
    title = f.readline().strip()
    print "     * [%s %s]" % (wikiname, title)


