#!/usr/bin/perl
# SourceForge.JP Wiki manipulator
# by hylom
# This code is under GPL.
#

use warnings;
use strict;

use lib '/Users/hylom/otptools';

use utf8;
use open IO => ':utf8';
use open ':std';

use Getopt::Std;
use SourceForgeJP;
use IO::File;
use Term::Prompt;
use URI::Escape;
use Encode;
use File::Temp;
use Path::Class;

my $usage = <<EOD;
s2wupload.pl <file>
EOD

my $filename= shift @ARGV;
unless( $filename ) {
    print $usage;
    exit;
}

#my $project = "test11";
my $project = "hpc-parallel";
my $filepath = file($filename);
my $parent_dir = $filepath->parent();

my $pagename = upload_text($filepath, $project);

sub upload_attachments {
    my $path = shift @_;
    my $project = shift @_;
    my $page = shift @_;

    my $dh = $path->open();
    while( my $file = $dh->read() ) {
	my $file = $path->file($file); # get Path::Class::File object.

	if( ! -e $file ) {
	    die "$file is not exist.\n";
	}
	my $fname = $file->stringify();
	if( not $fname =~ m/\.(jpg|JPG|png|PNG|gif|GIF)$/ ) {
	    next;
	}
	print STDERR "uploading:\n";
	print $file, "\n";
	my $sf = WWW::SourceForgeJP->new();
	my $ret = $sf->Wiki->post_attachment( project => $project,
					      page => $page,
					      file => $fname );

	if( $ret ) {
	    print "$file: upload succeed.\n";
	} else {
	    print "$file: upload failed.\n";
	}

    }
}

sub upload_text {
    my $fullpath = shift @_;
    my $project = shift @_;

    my $fh = $fullpath->open("r");
    if( ! $fh ) {
	print STDERR "can't open: $fullpath: $!";
	return
    }
    my $filename = <$fh>;
    chomp $filename;
    my $title = <$fh>;
    chomp $title;
    my $body = do { local( $/ ); <$fh> };
    close $fh;

    print STDERR "uploading:\n";
    print $filename, "\n";

    my $sf = WWW::SourceForgeJP->new();
    $sf->Wiki->edit_page( project => $project,
			  page => $filename,
			  text => $body,
			  title => $title,
			  comment => "" );

    return $filename;
}
