#!/usr/bin/perl
# SourceForge.JP Wiki manipulator
# by hylom
# This code is under GPL.
#

use warnings;
use strict;

use lib '/Users/hylom/otptools';

use utf8;
use open IO => ':utf8';
use open ':std';

use Getopt::Std;
use SourceForgeJP;
use IO::File;
use Term::Prompt;
use URI::Escape;
use Encode;
use File::Temp;
use Path::Class;

my $usage = <<EOD;
sfmag2wiki_upload.pl command <directory>

command is: {upload|login|logout}
EOD

my $command= shift @ARGV;
unless( $command ) {
    print $usage;
    exit;
}

if( $command eq 'login' ) {   #login
    my %opts;
    getopt('up', \%opts);
    my $login_name;
    my $password;

    if( defined $opts{'u'} ) {
	$login_name = $opts{'u'};
    } else {
      $login_name = prompt( 'x', 'loginname:', '', '' );
    }

    if( defined $opts{'p'} ) {
      $password = $opts{'p'};
    } else {
	$password = prompt( 'p', 'password:', '', '' );
	print "\n";
    }

    print "do login...\n";
    if( login( $login_name, $password) ) {
		print "ok.\n";
	} else {
		print "login failed.\n"
	}

} elsif( $command eq 'upload' ) {    #attach
    my $dir = shift @ARGV;
    if( $dir ) {
	upload( $dir )
    } else {
	print $usage;
	exit;
    }
} elsif( $command eq 'logout' ) {    #logout
    print "do logout...\n";
    logout();
} else {    #other
    print $usage;
    exit;
}

sub login {
    my $login_name = shift @_;
    my $password = shift @_;

    my $sf = WWW::SourceForgeJP->new();
    $sf->login( $login_name, $password );
}

sub logout {
    my $sf = WWW::SourceForgeJP->new();
    $sf->logout();
}

sub upload {
    my $project = "test11";
    my $target_dir = shift @_;

    opendir DH, $target_dir || die "can't open dir $target_dir: $!";
    while( my $dir = readdir DH ) {
	next if $dir eq ".";
	next if $dir eq "..";
	my $fullpath = file($target_dir, $dir, "wiki.txt");
	my $pagename = upload_text($fullpath, $project);
	my $pathdir = dir($target_dir, $dir);
	upload_attachments($pathdir, $project, $pagename);
    }
    closedir DH;
}

sub upload_attachments {
    my $path = shift @_;
    my $project = shift @_;
    my $page = shift @_;

    my $dh = $path->open();
    while( my $file = $dh->read() ) {
	my $file = $path->file($file); # get Path::Class::File object.

	if( ! -e $file ) {
	    die "$file is not exist.\n";
	}
	my $fname = $file->stringify();
	if( not $fname =~ m/\.(jpg|JPG|png|PNG|gif|GIF)$/ ) {
	    next;
	}
	print STDERR "uploading:\n";
	print $file, "\n";
	my $sf = WWW::SourceForgeJP->new();
	my $ret = $sf->Wiki->post_attachment( project => $project,
					      page => $page,
					      file => $fname );

	if( $ret ) {
	    print "$file: upload succeed.\n";
	} else {
	    print "$file: upload failed.\n";
	}

    }
}

sub upload_text {
    my $fullpath = shift @_;
    my $project = shift @_;

    my $fh = $fullpath->open("r");
    if( ! $fh ) {
	print STDERR "can't open: $fullpath: $!";
	return
    }
    my $filename = <$fh>;
    chomp $filename;
    my $title = <$fh>;
    chomp $title;
    my $body = do { local( $/ ); <$fh> };
    close $fh;

    print STDERR "uploading:\n";
    print $filename, "\n";

    my $sf = WWW::SourceForgeJP->new();
    $sf->Wiki->edit_page( project => $project,
			  page => $filename,
			  text => $body,
			  title => $title,
			  comment => "" );

    return $filename;
}
