#!/usr/bin/env python
# -*- coding: utf-8 -*-

import fetch_sfjpmag
import sys
import os.path

usage = "%s <url_list> <output_dir>" % sys.argv[0]

try:
    urllist = sys.argv[1]
    output_dir = sys.argv[2]
except IndexError:
    sys.exit(usage)

if not os.path.isdir(output_dir):
    sys.exit(usage)

try:
    f = open(urllist, "r")
except IOError:
    sys.exit(usage)

for url in f:
    if url[0] == "#":
        continue

    url = url.strip()
    fetch_sfjpmag.fetch(url, output_dir)

