#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""Test suite for spyder.py."""

import unittest
import re
import html2sfjpwiki

class TestSequenceFunctions(unittest.TestCase):
    def setUp(self):
        self.test_file = "fetch_test/09/09/10/1214252/1/body.html"
        fh = open(self.test_file, "r")
        html = fh.read()
        fh.close()

        rex = re.compile(r"<\s*script[^>]*?>.*?</script>", re.S)
        rex2 = re.compile(r"<\s*noscript[^>]*?>.*?</noscript>", re.S)
        tmp = rex.sub("", html)
        self.test_data = rex2.sub("", tmp)

    def test_convert(self):
        """test for convert"""
        c = html2sfjpwiki.Html2SfjpWiki()
        r = c.parse(self.test_data, "article-body")
        print r


# do unittest
suite = unittest.TestLoader().loadTestsFromTestCase(TestSequenceFunctions)
unittest.TextTestRunner(verbosity=2).run(suite)

