#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""Test suite for spyder.py."""

import unittest
import os.path
import codecs

import spyder


class TestSequenceFunctions(unittest.TestCase):
    def setUp(self):
        self.test_html = """<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en"
 lang="en" dir="ltr">
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <title>Spyder test HTML</title>
  </head>
<body class='sidebar_inside_left'>
<form action="" method="post" >
<input type="hidden" name="sectok" value="d1edf02df0138c3a7307e24a371115e9" />
<input type="hidden" name="id" value="home" />
<input type="hidden" name="rev" value="" />
<input type="hidden" name="date" value="1239099312" />
<input type="hidden" name="prefix" value="" />
<input type="hidden" name="suffix" value="" />
<input type="hidden" name="changecheck" value="288b43989cd8dfa23319573916dfd16d" />
<textarea name="wikitext" id="wiki__text" class="edit" cols="80" rows="10" tabindex="1" >
This is text codes.
foo bar hoge hoge
</textarea>
</form>
<div class="footerinc">
  <a  href="/wiki/feed.php" title="Recent changes RSS feed"><img src="/wiki/lib/tpl/sidebar/images/button-rss.png" width="80" height="15" alt="Recent changes RSS feed" /></a>
        <a  href="http://creativecommons.org/licenses/by-nc-sa/3.0/" rel="license" title="CC Attribution-Noncommercial-Share Alike 3.0 Unported"><img src="/wiki/lib/images/license/button/cc-by-nc-sa.png" width="80" height="15" alt="" /></a>
  <a  href="http://www.dokuwiki.org/donate" title="Donate"><img src="/wiki/lib/tpl/sidebar/images/button-donate.gif" alt="Donate" width="80" height="15" /></a>
  <a  href="http://www.php.net" title="Powered by PHP"><img src="/wiki/lib/tpl/sidebar/images/button-php.gif" width="80" height="15" alt="Powered by PHP" /></a>
  <a  href="http://validator.w3.org/check/referer" title="Valid XHTML 1.0"><img src="/wiki/lib/tpl/sidebar/images/button-xhtml.png" width="80" height="15" alt="Valid XHTML 1.0" /></a>
  <a  href="http://jigsaw.w3.org/css-validator/check/referer?profile=css3" title="Valid CSS"><img src="/wiki/lib/tpl/sidebar/images/button-css.png" width="80" height="15" alt="Valid CSS" /></a>
  <a  href="http://dokuwiki.org/" title="Driven by DokuWiki"><img src="/wiki/lib/tpl/sidebar/images/button-dw.png" width="80" height="15" alt="Driven by DokuWiki" /></a>
  <a  href="hogehoge" title="hogehoge"><img src="/wiki/lib/tpl/sidebar/images/button-dw.png" width="80" height="15" alt="Driven by DokuWiki" /></a>
</div>
</body>
</html>
"""

    def test_extract_anchors(self):
        """test for AnchorParser"""

        ret_ok = ["http://ffdshow-tryout.sourceforge.net/wiki/feed.php",
                  "http://creativecommons.org/licenses/by-nc-sa/3.0/",
                  "http://www.dokuwiki.org/donate",
                  "http://www.php.net",
                  "http://validator.w3.org/check/referer",
                  "http://jigsaw.w3.org/css-validator/check/referer?profile=css3",
                  "http://dokuwiki.org/",
                  "http://ffdshow-tryout.sourceforge.net/wiki/hogehoge"]
        
        p = spyder.AnchorParser()
        ret = p.extract_anchors(self.test_html, "http://ffdshow-tryout.sourceforge.net/wiki/home")
        self.assertEqual(len(ret), len(ret_ok))
        ret.sort()
        ret_ok.sort()
        for index in range(len(ret)):
            self.assertEqual(ret[index], ret_ok[index])



# do unittest
suite = unittest.TestLoader().loadTestsFromTestCase(TestSequenceFunctions)
unittest.TextTestRunner(verbosity=2).run(suite)

