#!/usr/bin/env python
# -*- coding: utf-8 -*-
 
import sys
import os
import re
import codecs
import pickle
import markupper
import HTMLTagFilter

#sys.stdin = codecs.getreader('utf_8')(sys.stdin)
#sys.stdout = codecs.getwriter('utf_8')(sys.stdout)

class WikiMarkupper(markupper.Markupper):
    def _head_l(self, line):
        line = self._default_markup_rule(line)
        if self._anchor != "":
            line = re.sub(ur"^●(.*)$", ur'== \1 == #%s' % self._anchor, line)
            self._anchor = ""
        else:
            line = re.sub(ur"^●(.*)$", ur"== \1 ==", line)
        print line

    def _head_m(self, line):
        line = self._default_markup_rule(line)
        if self._anchor != "":
            line = re.sub(ur"^○(.*)$", ur'=== \1 === #%s' % self._anchor, line)
            self._anchor = ""
        else:
            line = re.sub(ur"^○(.*)$", ur"=== \1 ===", line)
        print line

    def _paragraph(self, line):
        line = self._default_markup_rule(line)
        print line,

    def _newpage(self, line):
        pass

    def _default_markup_rule(self, line):
        """
        apply default markup rules.

        @param line: string to apply markup
        @type line: string
        """
        # line = re.sub(ur"&", ur"&amp", line)
        # line = re.sub(ur"<", ur"&lt;", line)
        # line = re.sub(ur">", ur"&gt;", line)

        # apply filter
        # line = tag_filter.apply(line)

        line = re.sub(ur"[★*](表[0-9～、]+)", ur"'''\1'''", line)
        line = re.sub(ur"[★*](図[0-9～、]+)", ur"'''\1'''", line)
        line = re.sub(ur"[★*](リスト[0-9～、]+)", ur"'''\1'''", line)
        line = re.sub(ur"[★*]b\[(.*?)\]", ur"'''\1'''", line)
        line = re.sub(ur"[★*]b\{(.*?)\}", ur"'''\1'''", line)
        line = re.sub(ur"[★*]\[(\S*) (.*?)\]", r'[\1 \2]', line)
        line = re.sub(ur"[★*]\[(\S*)\]", r'[\1]', line)

        return line


    def _ulist(self, line):
        """Proccess ul"""
        while re.search(ur"^・", line):
            line = self._default_markup_rule(line)
            print re.sub(ur"^・(.*)$", ur" * \1", line.strip())
            line = self.input_iter.next()

    def _begin_column(self, line):
        """Proccess column"""
        try:
            str_title = re.search(ur"^☆begin-column:(.*)$", line).group(1)
        except AttributeError:
            str_title = ""

        html = """=== %s ===""" % (str_title)
        print html

    def _end_column(self, line):
        pass

    def _list_start(self):
        return "{{{"

    def _list_end(self):
        return "}}}"

    def _list(self, line):
        try:
            str_title = re.search(ur"^☆(リスト.*)$", line).group(1)
        except AttributeError:
            str_title = ""
        print "'''%s'''" % (str_title)
        print self._list_start()

        for line in self.input_iter:
            line = line.strip("\n\r")
            if re.search(ur"""^☆\+---""", line):
                break
            print line
        print self._list_end()

    def _code(self, line):
        print self._list_start()

        for line in self.input_iter:
            #        line = line.strip()
            line = line = re.sub(ur"[★*]b\[(.*?)]", ur"\1", line)
            line = line = re.sub(ur"[★*]b{(.*?)}", ur"\1", line)

            if re.search(ur"^☆\+---$", line):
                break
            print line,
        print self._list_end()


    def _inline(self, line):
        print "{{{ html"
        for line in self.input_iter:
            #        line = line.strip()
            if re.search(ur"^☆}}}", line):
                break
            print line,
        print "}}}"

    def _comment(self, line):
        for line in self.input_iter:
            line = line.strip()
            if re.search(ur"^☆}}}", line):
                break

    def _space(self, line):
        print "[[BR]]"

    def _flow(self, line):
        flow_header = """{{{ html
<div style="text-align:center; border: 1px solid; background-color:#EFF2F0; width:90%; margin: 0 auto 1em;">
"""
        flow_title = """<div style="text-align:left; padding:4px 4px 4px 1em; margin-bottom: 1em; border-bottom: 1px solid; font-weight: bold; background-color:#BCD;">
%s
</div>"""
        flow_footer = """</div>
}}}
"""
        flow_item = """<div>
}}}
%s
{{{ html
</div>

"""
        down_arrow = "http://static.sourceforge.jp/crystal/22x22/actions/1downarrow.png"

        rex_title = re.compile(ur"^☆flow\s+(.*)$")
        if rex_title.search(line):
            title = rex_title.search(line).group(1)
        else:
            title = ""

        rex_file = re.compile(ur"^([^:]*):(.*)$")
        outputs = []
        for line in self.input_iter:
            if re.search(r"^\s*$", line):
                break
            match = rex_file.search(line)
            if match:
                #file = os.path.join(self._image_dir, match.group(1))
                file = match.group(1)
                cap = match.group(2)
            else:
                continue
            fig = self._anchored_fig(file, cap)
            outputs.append(flow_item % (fig))

        arrow = '<div style="margin: 1em auto;"><img src="%s"></div>\n' % (down_arrow,)
        print flow_header
        print flow_title % (title,)
        print arrow.join(outputs)
        print flow_footer
        

    def _fig_start(self, cap=""):
        return ""

    def _fig_end(self, cap=""):
        return ""

    def _fig(self, line):
        if self._release == 1:
            self._fig_release(line)
        else:
            self._fig_org(line)


    def _fig_org(self, line):
        try:
            str_title = re.search(ur"^☆(図.*)$", line).group(1)
        except AttributeError:
            str_title = ""
        if str_title.find(u"図*") == 0:
            str_title = str_title.replace(u"図*", "")
        print self._fig_start()

        line = self.input_iter.next()
        imgname = ""
        imgname_s = ""
        hash = ""
        hash_s = ""
        match_o1 = re.search(ur"<([^,]*?)>", line)
        match_o2 = re.search(ur"<(.*?),\s*(.*?)>", line)
        if not match_o1 == None:
            imgname = match_o1.group(1)
            #imgname = os.path.join(self._image_dir, imgname)
            imgname_s = re.sub(r"(.[A-Za-z0-9_]+)$", r"_s\1", imgname)
        elif not match_o2 == None:
            imgname = match_o1.group(1)
            #imgname = os.path.join(self._image_dir, imgname)
            imgname_s = match_o1.group(2)

        print self._anchored_fig(imgname, str_title, imgname_s)

#         if not os.path.isfile(imgname_s):
#             imgname_s = imgname

#         print """<a href="%s">
#      <img src="%s" alt="%s">
# </a>
#      """ % (imgname, imgname_s, str_title)

        dic = self.index("figs")
        dic.append(imgname)
        if imgname_s != "":
            dic.append(imgname_s)

        print self._fig_end(str_title);
        
    def _anchored_fig(self, file, alt, file_s=""):

        if file_s == "":
            file_s = re.sub(r"(.[A-Za-z0-9_]+)$", r"_s\1", file)

        if not os.path.isfile(file_s):
            file_s = file

        return """[[Thumb(%s, size=large, caption=%s)]]""" % (file, alt)
        

    def _fig_release(self, line):
        try:
            str_title = re.search(ur"^☆(図.*)$", line).group(1)
        except AttributeError:
            str_title = ""
        print self._fig_start()

        line = self.input_iter.next()
        imgname = ""
        imgname_s = ""
        hash = ""
        hash_s = ""
        match_o1 = re.search(ur"<([^,]*?)>", line)
        match_o2 = re.search(ur"<(.*?),\s*(.*?)>", line)
        if not match_o1 == None:
            imgname = match_o1.group(1)
            imgname_s = re.sub(r"(.[A-Za-z0-9_]+)$", r"_s\1", match_o1.group(1))
        elif not match_o2 == None:
            imgname = match_o1.group(1)
            imgname_s = match_o1.group(2)


        hash = self.hashlist.get(imgname, "")
        hash_s = self.hashlist.get(imgname_s, "")
        if hash_s == "":
            hash_s = hash

        print """<a href="/blob.pl?id=%s">
     <slash type="image" id="%s" title="%s">
     </a>
     """ % (hash, hash_s, str_title)
        

        dic = self.index("figs")
        dic.append(imgname)
        if imgname_s != "":
            dic.append(imgname_s)

        print self._fig_end(str_title);


    def _table_start(self, cap):
        return "'''%s'''" % (cap,)

    def _table_end(self, footnote=""):
        return "%s" % (footnote,)

    def _table(self, line):
        str_title = ""
        self._table_buf1 = ""

        try:
            str_title = re.search(ur"^☆(表.*)$", line).group(1)
            fig_name =  re.search(ur"^☆(表[0-9A-Z]*)", line).group(1)
        except AttributeError:
            str_title = ""
            fig_name = ""
        if str_title.find(u"表*") == 0:
            str_title = str_title.replace(u"表*", "")
#        print self._table_start(str_title)
        self._table_buf1 =  self._table_start(str_title) + "\n"

        num_row = 0
        table_contents = []
        footnote = ""
        for line in self.input_iter:
            line = line.strip(" \n")
            line = self._default_markup_rule(line)
            if re.search(ur"^\s*$", line):
                break
            if re.search(ur"^※", line):
                footnote = re.search(ur"^(※.*)$", line).group(1)
                break
            line = self._default_markup_rule(line)
            if re.search(ur"^〓", line):
                line = re.sub(ur"^〓", "", line)
                tag_mode = "th"
            else:
                tag_mode = "td"
            self._table_buf1 = self._table_buf1 + "||"
            for item in line.split("\t"):
                if tag_mode == "th":
                    self._table_buf1 = self._table_buf1 + "'''%s'''||" % (item,)
                else:
                    self._table_buf1 = self._table_buf1 + "%s||" % (item,)
            self._table_buf1 = self._table_buf1 + "\n"

        self._table_buf1 = self._table_buf1 + self._table_end(footnote)
        print self._table_buf1
        if self.index_haskey("tables"):
            self.index("tables")[fig_name] = self._table_buf1
        else:
            self.index_add("tables", {fig_name:self._table_buf1})

    def _call_tables(self, line):
        try:
            fig_name =  re.search(ur"^☆call_tables\((表[0-9A-Z]+)", line).group(1)
        except AttributeError:
            return
        print self.index("tables")[fig_name]
