<?php

require_once P2_LIB_DIR . '/FileCtl.php';
require_once P2_LIB_DIR . '/Session.php';

// {{{ Login

/**
 * rep2 - OCF؂NX
 *
 * @create  2005/6/14
 * @author aki
 */
class Login
{
    // {{{ properties

    public $user;   // [UiIȂ́j
    public $user_u; // [Ui[UƒڐG镔j
    public $pass_x; // ÍꂽpX[h

    // }}}
    // {{{ constructor

    /**
     * RXgN^
     */
    public function __construct()
    {
        $login_user = $this->setdownLoginUser();

        // [Uw肳ĂȂ
        if ($login_user == NULL) {

            // OCs
            require_once P2_LIB_DIR . '/login_first.inc.php';
            printLoginFirst($this);
            exit;
        }

        $this->setUser($login_user);
        $this->pass_x = NULL;
    }

    // }}}
    // {{{ setUser()

    /**
     * [UZbg
     */
    public function setUser($user)
    {
        $this->user_u = $user;
        $this->user = $user;
    }

    // }}}
    // {{{ setdownLoginUser()

    /**
     * OC[U̎w𓾂
     */
    public function setdownLoginUser()
    {
        $login_user = NULL;

        // [U̗D揇ʂɉ

        // OCtH[̎w
        if (!empty($GLOBALS['brazil'])) {
            $add_mail = '.,@-';
        } else {
            $add_mail = '';
        }
        if (isset($_REQUEST['form_login_id']) && preg_match("/^[0-9A-Za-z_{$add_mail}]+\$/", $_REQUEST['form_login_id'])) {
            $login_user = $this->setdownLoginUserWithRequest();

        // GETł̎w
        } elseif (isset($_REQUEST['user']) && preg_match("/^[0-9A-Za-z_{$add_mail}]+\$/", $_REQUEST['user'])) {
            $login_user = $_REQUEST['user'];

        // CookieŎw
        } elseif (isset($_COOKIE['cid']) && ($user = $this->getUserFromCid($_COOKIE['cid'])) !== false) {
            if (preg_match("/^[0-9A-Za-z_{$add_mail}]+\$/", $user)) {
                $login_user = $user;
            }

        // SessionŎw
        } elseif (isset($_SESSION['login_user']) && preg_match("/^[0-9A-Za-z_{$add_mail}]+\$/", $_SESSION['login_user'])) {
            $login_user = $_SESSION['login_user'];

        /*
        // BasicF؂Ŏw
        } elseif (!empty($_REQUEST['basic'])) {

            if (isset($_SERVER['PHP_AUTH_USER']) && (preg_match("/^[0-9A-Za-z_{$add_mail}]+\$/", $_SERVER['PHP_AUTH_USER']))) {
                $login_user = $_SERVER['PHP_AUTH_USER'];

            } else {
                header('WWW-Authenticate: Basic realm="zone"');
                header('HTTP/1.0 401 Unauthorized');
                echo 'Login Failed. [UF؂Ɏs܂B';
                exit;
            }
        */

        }

        return $login_user;
    }

    // }}}
    // {{{ setdownLoginUserWithRequest()

    /**
     * REQUEST烍OC[U̎w𓾂
     */
    public function setdownLoginUserWithRequest()
    {
        return $_REQUEST['form_login_id'];
    }

    // }}}
    // {{{ authorize()

    /**
     * F؂s
     */
    public function authorize()
    {
        global $_conf, $_p2session;

        // {{{ F؃`FbN

        if (!$this->_authCheck()) {
            // OCs
            require_once P2_LIB_DIR . '/login_first.inc.php';
            printLoginFirst($this);
            exit;
        }

        // }}}

        // OCOKȂ

        // {{{ OAEg̎w肪

        if (!empty($_REQUEST['logout'])) {

            // ZbVNAiANeBuAANeBu킸j
            Session::unSession();

            // ⏕F؂NA
            $this->clearCookieAuth();

            $mobile = Net_UserAgent_Mobile::singleton();

            if ($mobile->isEZweb()) {
                $this->_registAuthOff($_conf['auth_ez_file']);

            } elseif ($mobile->isSoftBank()) {
                $this->_registAuthOff($_conf['auth_jp_file']);

            /* DoCoMo̓OCʂ\̂ŁA⏕F؏jȂ
            } elseif ($mobile->isDoCoMo()) {
                $this->_registAuthOff($_conf['auth_imodeid_file']);
                $this->_registAuthOff($_conf['auth_docomo_file']);
            */
            }

            // $user_u_q = $_conf['ktai'] ? "?user={$this->user_u}" : '';

            $url = rtrim(dirname(P2Util::getMyUrl()), '/') . '/'; // . $user_u_q;

            header('Location: '.$url);
            exit;
        }

        // }}}
        // {{{ ZbVpĂȂAZbVϐ̍XV

        if (isset($_p2session)) {

            // [UƃpXXXV
            $_SESSION['login_user']   = $this->user_u;
            $_SESSION['login_pass_x'] = $this->pass_x;
        }

        // }}}
        // {{{ v΁A⏕F؂o^

        $this->registCookie();
        $this->registKtaiId();

        // }}}

        // F،̓ZbV
        if (!defined('P2_SESSION_NO_CLOSE')) {
            session_write_close();
        }

        return true;
    }

    // }}}
    // {{{ checkAuthUserFile()

    /**
     * F؃[Uݒ̃t@C𒲂ׂāAȃf[^Ȃ̂ĂĂ܂
     */
    public function checkAuthUserFile()
    {
        global $_conf;

        if (@include($_conf['auth_user_file'])) {
            // [U񂪂ȂAt@ĈĂĔ
            if (empty($rec_login_user_u) || empty($rec_login_pass_x)) {
                unlink($_conf['auth_user_file']);
            }
        }

        return true;
    }

    // }}}
    // {{{ _authCheck()

    /**
     * F؂̃`FbNs
     *
     * @return bool
     */
    private function _authCheck()
    {
        global $_info_msg_ht, $_conf;
        global $_login_failed_flag;
        global $_p2session;

        $this->checkAuthUserFile();

        // F؃[Uݒit@Cjǂݍ݂ł
        if (file_exists($_conf['auth_user_file'])) {
            include $_conf['auth_user_file'];

            // [UAF؎sŔ
            if ($this->user_u != $rec_login_user_u) {
                $_info_msg_ht .= '<p class="infomsg">p2 error: OCG[</p>';

                // OCsOL^
                if (!empty($_conf['login_log_rec'])) {
                    $recnum = isset($_conf['login_log_rec_num']) ? intval($_conf['login_log_rec_num']) : 100;
                    P2Util::recAccessLog($_conf['login_failed_log_file'], $recnum);
                }

                return false;
            }

            // pX[hݒ肪΁AZbg
            if (isset($rec_login_pass_x) && strlen($rec_login_pass_x) > 0) {
                $this->pass_x = $rec_login_pass_x;
            }
        }

        // Fؐݒ or pX[hL^Ȃꍇ͂܂
        if (!$this->pass_x) {

            // VKo^łȂ΃G[\
            if (empty($_POST['submit_new'])) {
                $_info_msg_ht .= '<p class="infomsg">p2 error: OCG[</p>';
            }

            return false;
        }

        // {{{ NbL[F؃pXX[

        if (isset($_COOKIE['cid'])) {

            if ($this->checkUserPwWithCid($_COOKIE['cid'])) {
                return true;

            // CookieF؂ʂȂ
            } else {
                // ÂNbL[NAĂ
                $this->clearCookieAuth();
            }
        }

        // }}}
        // {{{ łɃZbVo^ĂAZbVŔF

        if (isset($_SESSION['login_user']) && isset($_SESSION['login_pass_x'])) {

            // ZbVpĂȂAZbV̑Ó`FbN
            if (isset($_p2session)) {
                if ($msg = $_p2session->checkSessionError()) {
                    $GLOBALS['_info_msg_ht'] .= '<p>p2 error: ' . htmlspecialchars($msg) . '</p>';
                    //Session::unSession();
                    // OCs
                    return false;
                }
            }

            if ($this->user_u == $_SESSION['login_user']) {
                if ($_SESSION['login_pass_x'] != $this->pass_x) {
                    Session::unSession();
                    return false;

                } else {
                    return true;
                }
            }
        }

        // }}}

        $mobile = Net_UserAgent_Mobile::singleton();

        // {{{ DoCoMo i[hIDF

        /**
         * @link http://www.nttdocomo.co.jp/service/imode/make/content/ip/index.html#imodeid
         */
        if (!isset($_GET['auth_type']) || $_GET['auth_type'] == 'imodeid') {
            if ($mobile->isDoCoMo() && ($UID = $mobile->getUID()) !== null) {
                if (file_exists($_conf['auth_imodeid_file'])) {
                    include $_conf['auth_imodeid_file'];
                    if (isset($registed_imodeid) && $registed_imodeid == $UID) {
                        if (!$this->_checkIp('docomo')) {
                            p2die('[IDF؃G[',
                                  "UADoCoMo[łAi[hIPAhXшƃ}b`܂B({$_SERVER['REMOTE_ADDR']})");
                        }
                        return true;
                    }
                }
            }
        }

        // }}}
        // {{{ DoCoMo [ԍF

        /**
         * OCtH[͂͗pApF؃N̂ݗp
         * @link http://www.nttdocomo.co.jp/service/imode/make/content/html/tag/utn.html
         */
        if (isset($_GET['auth_type']) && $_GET['auth_type'] == 'utn') {
            if ($mobile->isDoCoMo() && ($SN = $mobile->getSerialNumber()) !== null) {
                if (file_exists($_conf['auth_docomo_file'])) {
                    include $_conf['auth_docomo_file'];
                    if (isset($registed_docomo) && $registed_docomo == $SN) {
                        if (!$this->_checkIp('docomo')) {
                            p2die('[IDF؃G[',
                                  "UADoCoMo[łAi[hIPAhXшƃ}b`܂B({$_SERVER['REMOTE_ADDR']})");
                        }
                        return true;
                    }
                }
            }
        }

        // }}}
        // {{{ EZweb TuXNCoIDF

        /**
         * @link http://www.au.kddi.com/ezfactory/tec/spec/4_4.html
         */
        if ($mobile->isEZweb() && ($UID = $mobile->getUID()) !== null) {
            if (file_exists($_conf['auth_ez_file'])) {
                include $_conf['auth_ez_file'];
                if (isset($registed_ez) && $registed_ez == $UID) {
                    if (!$this->_checkIp('au')) {
                        p2die('[IDF؃G[',
                              "UAau[łAEZwebIPAhXшƃ}b`܂B({$_SERVER['REMOTE_ADDR']})");
                    }
                    return true;
                }
            }
        }

        // }}}
        // {{{ SoftBank [VAԍF

        /**
         * pPbgΉ@ v[UIDʒmON̐ݒ
         * @link http://creation.mb.softbank.jp/web/web_ua_about.html
         */
        if ($mobile->isSoftBank() && ($SN = $mobile->getSerialNumber()) !== null) {
            if (file_exists($_conf['auth_jp_file'])) {
                include $_conf['auth_jp_file'];
                if (isset($registed_jp) && $registed_jp == $SN) {
                    if (!$this->_checkIp('softbank')) {
                        p2die('[IDF؃G[',
                              "UASoftBank[łASoftBank MobileIPAhXшƃ}b`܂B({$_SERVER['REMOTE_ADDR']})");
                    }
                    return true;
                }
            }
        }

        // }}}
        // {{{ tH[烍OC

        if (!empty($_POST['submit_member'])) {

            // tH[OCȂ
            if ($_POST['form_login_id'] == $this->user_u and sha1($_POST['form_login_pass']) == $this->pass_x) {

                // ÂNbL[NAĂ
                $this->clearCookieAuth();

                // OCOL^
                $this->logLoginSuccess();

                return true;

            // tH[OCsȂ
            } else {
                $_info_msg_ht .= '<p class="infomsg">p2 info: OCł܂łB<br>[UpX[hႢ܂B</p>';
                $_login_failed_flag = true;

                // OCsOL^
                $this->logLoginFailed();

                return false;
            }
        }

        // }}}
        // {{{ BasicF (disabled)

        /*
        if (!empty($_REQUEST['basic'])) {
            if (isset($_SERVER['PHP_AUTH_USER']) and ($_SERVER['PHP_AUTH_USER'] == $this->user_u) && (sha1($_SERVER['PHP_AUTH_PW']) == $this->pass_x)) {

                // ÂNbL[NAĂ
                $this->clearCookieAuth();

                // OCOL^
                $this->logLoginSuccess();

                return true;

            } else {

                header('WWW-Authenticate: Basic realm="zone"');
                header('HTTP/1.0 401 Unauthorized');
                echo 'Login Failed. [UF؂Ɏs܂B';

                // OCsOL^
                $this->logLoginFailed();

                exit;
            }
        }
        */

        // }}}

        return false;
    }

    // }}}
    // {{{ logLoginSuccess()

    /**
     * OCOL^
     */
    public function logLoginSuccess()
    {
        global $_conf;

        if (!empty($_conf['login_log_rec'])) {
            $recnum = isset($_conf['login_log_rec_num']) ? intval($_conf['login_log_rec_num']) : 100;
            P2Util::recAccessLog($_conf['login_log_file'], $recnum);
        }

        return true;
    }

    // }}}
    // {{{ logLoginFailed()

    /**
     * OCsOL^
     */
    public function logLoginFailed()
    {
        global $_conf;

        if (!empty($_conf['login_log_rec'])) {
            $recnum = isset($_conf['login_log_rec_num']) ? intval($_conf['login_log_rec_num']) : 100;
            P2Util::recAccessLog($_conf['login_failed_log_file'], $recnum, 'txt');
        }

        return true;
    }

    // }}}
    // {{{ registKtaiId()

    /**
     * gїp[ID̔Fؓo^Zbg
     */
    public function registKtaiId()
    {
        global $_conf, $_info_msg_ht;

        $mobile = Net_UserAgent_Mobile::singleton();

        // {{{ Fؓo^ DoCoMo i[hID & [ԍ

        if (!empty($_REQUEST['ctl_regist_imodeid']) || !empty($_REQUEST['ctl_regist_docomo'])) {
            // {{{ i[hID

            if (!empty($_REQUEST['ctl_regist_imodeid'])) {
                if (isset($_REQUEST['regist_imodeid']) && $_REQUEST['regist_imodeid'] == '1') {
                    if (!$mobile->isDoCoMo() || !$this->_checkIp('docomo')) {
                        p2die('[IDo^G[',
                              "UADoCoMo[łȂAi[hIPAhXшƃ}b`܂B({$_SERVER['REMOTE_ADDR']})");
                    }
                    if (($UID = $mobile->getUID()) !== null) {
                        $this->_registAuth('registed_imodeid', $UID, $_conf['auth_imodeid_file']);
                    } else {
                        $_info_msg_ht .= '<p class="infomsg">~DoCoMo i[hIDł̔Fؓo^͂ł܂ł</p>'."\n";
                    }
                } else {
                    $this->_registAuthOff($_conf['auth_imodeid_file']);
                }
            }

            // }}}
            // {{{ [ԍ

            if (!empty($_REQUEST['ctl_regist_docomo'])) {
                if (isset($_REQUEST['regist_docomo']) && $_REQUEST['regist_docomo'] == '1') {
                    if (!$mobile->isDoCoMo() || !$this->_checkIp('docomo')) {
                        p2die('[IDo^G[',
                              "UADoCoMo[łȂAi[hIPAhXшƃ}b`܂B({$_SERVER['REMOTE_ADDR']})");
                    }
                    if (($SN = $mobile->getSerialNumber()) !== null) {
                        $this->_registAuth('registed_docomo', $SN, $_conf['auth_docomo_file']);
                    } else {
                        $_info_msg_ht .= '<p class="infomsg">~DoCoMo [ԍł̔Fؓo^͂ł܂ł</p>'."\n";
                    }
                } else {
                    $this->_registAuthOff($_conf['auth_docomo_file']);
                }
            }

            // }}}
            return;
        }

        // }}}
        // {{{ Fؓo^ EZweb TuXNCoID

        if (!empty($_REQUEST['ctl_regist_ez'])) {
            if (isset($_REQUEST['regist_ez']) && $_REQUEST['regist_ez'] == '1') {
                if (!$mobile->isEZweb() || !$this->_checkIp('au')) {
                    p2die('[IDo^G[',
                          "UAau[łȂAEZwebIPAhXшƃ}b`܂B({$_SERVER['REMOTE_ADDR']})");
                }
                if (($UID = $mobile->getUID()) !== null) {
                    $this->_registAuth('registed_ez', $UID, $_conf['auth_ez_file']);
                } else {
                    $_info_msg_ht .= '<p class="infomsg">~EZweb TuXNCoIDł̔Fؓo^͂ł܂ł</p>'."\n";
                }
            } else {
                $this->_registAuthOff($_conf['auth_ez_file']);
            }
            return;
        }

        // }}}
        // {{{ Fؓo^ SoftBank [VAԍ

        if (!empty($_REQUEST['ctl_regist_jp'])) {
            if (isset($_REQUEST['regist_jp']) && $_REQUEST['regist_jp'] == '1') {
                if (!$mobile->isSoftBank() || !$this->_checkIp('softbank')) {
                    p2die('[IDo^G[',
                          "UASoftBank[łȂASoftBank MobileIPAhXшƃ}b`܂B({$_SERVER['REMOTE_ADDR']})");
                }
                if (($SN = $mobile->getSerialNumber()) !== null) {
                    $this->_registAuth('registed_jp', $SN, $_conf['auth_jp_file']);
                } else {
                    $_info_msg_ht .= '<p class="infomsg">~SoftBank [VAԍł̔Fؓo^͂ł܂ł</p>'."\n";
                }
            } else {
                $this->_registAuthOff($_conf['auth_jp_file']);
            }
            return;
        }

        // }}}
    }

    // }}}
    // {{{ _registAuth()

    /**
     * [IDF؃t@Co^
     */
    private function _registAuth($key, $sub_id, $auth_file)
    {
        global $_conf, $_info_msg_ht;

        $cont = <<<EOP
<?php
\${$key}='{$sub_id}';
?>
EOP;
        FileCtl::make_datafile($auth_file, $_conf['pass_perm']);
        $fp = fopen($auth_file, 'wb');
        if (!$fp) {
            $_info_msg_ht .= "<p>Error: f[^ۑł܂łBFؓo^sB</p>";
            return false;
        }
        flock($fp, LOCK_EX);
        fwrite($fp, $cont);
        flock($fp, LOCK_UN);
        fclose($fp);
        return true;
    }

    // }}}
    // {{{ _registAuthOff()

    /**
     * [ID̔F؃t@Co^O
     */
    private function _registAuthOff($auth_file)
    {
        if (file_exists($auth_file)) {
            unlink($auth_file);
        }
    }

    // }}}
    // {{{ makeUser()

    /**
     * VK[U쐬
     */
    public function makeUser($user_u, $pass)
    {
        global $_conf;

        $crypted_login_pass = sha1($pass);
        $auth_user_cont = <<<EOP
<?php
\$rec_login_user_u = '{$user_u}';
\$rec_login_pass_x = '{$crypted_login_pass}';
?>
EOP;
        FileCtl::make_datafile($_conf['auth_user_file'], $_conf['pass_perm']); // t@CȂΐ
        if (FileCtl::file_write_contents($_conf['auth_user_file'], $auth_user_cont) === false) {
            p2die("{$_conf['auth_user_file']} ۑł܂łBF{$p_str['user']}o^sB");
        }

        return true;
    }

    // }}}
    // {{{ registCookie()

    /**
     * cookieF؂o^/
     */
    public function registCookie()
    {
        if (!empty($_REQUEST['ctl_regist_cookie'])) {
            if ($_REQUEST['regist_cookie'] == '1') {
                $this->setCookieCid($this->user_u, $this->pass_x);
            } else {
                // NbL[NA
                $this->clearCookieAuth();
            }
        }
    }

    // }}}
    // {{{ clearCookieAuth()

    /**
     * CookieF؂NA
     */
    public function clearCookieAuth()
    {
        setcookie('cid', '', time() - 3600);
        /*
        setcookie('p2_user', '', time() - 3600);    //  p~vf 2005/6/13
        setcookie('p2_pass', '', time() - 3600);    //  p~vf 2005/6/13
        setcookie('p2_pass_x', '', time() - 3600);  //  p~vf 2005/6/13
        */
        $_COOKIE = array();

        return true;
    }

    // }}}
    // {{{ setCookieCid()

    /**
     * CIDcookieɃZbg
     *
     * @return boolean
     */
    public function setCookieCid($user_u, $pass_x)
    {
        global $_conf;

        if ($cid = $this->makeCid($user_u, $pass_x)) {
            $time = time() + 60*60*24 * $_conf['cid_expire_day'];
            setcookie('cid', $cid, $time);
            return true;
        } else {
            return false;
        }
    }

    // }}}
    // {{{ makeCid()

    /**
     * IDPASSƎԂ߂ĈÍCookieiCIDj𐶐擾
     *
     * @return mixed
     */
    public function makeCid($user_u, $pass_x)
    {
        if (is_null($user_u) || is_null($pass_x)) {
            return false;
        }

        require_once P2_LIB_DIR . '/md5_crypt.inc.php';

        $key = $this->getMd5CryptKey();

        $idtime = $user_u. ':'. time(). ':';
        $pw_enc = md5($idtime . $pass_x);
        $str = $idtime . $pw_enc;
        $cid = md5_encrypt($str, $key, 32);

        return $cid;
    }

    // }}}
    // {{{ getCidInfo()

    /**
     * CookieiCIDj烆[U𓾂
     *
     * @return array|false ΔzAsȂ false Ԃ
     */
    public function getCidInfo($cid)
    {
        global $_conf;

        require_once P2_LIB_DIR . '/md5_crypt.inc.php';

        $key = $this->getMd5CryptKey();

        $dec = md5_decrypt($cid, $key, 32);
        list($user, $time, $pw_enc) = split(':', $dec, 3);

        // L 
        if (time() > $time + (86400 * $_conf['cid_expire_day'])) {
            return false; // ؂
        } else {
            return array($user, $time, $pw_enc);
        }
    }

    // }}}
    // {{{ getUserFromCid()

    /**
     * CookieiCIDjuser𓾂
     *
     * @return mixed
     */
    public function getUserFromCid($cid)
    {
        if (!$ar = $this->getCidInfo($cid)) {
            return false;
        }

        return $user = $ar[0];
    }

    // }}}
    // {{{ checkUserPwWithCid()

    /**
     * CookieiCIDjuser, passƍ
     *
     * @return boolean
     */
    public function checkUserPwWithCid($cid)
    {
        global $_conf;

        if (is_null($this->user_u) || is_null($this->pass_x) || is_null($cid)) {
            return false;
        }

        if (!$ar = $this->getCidInfo($cid)) {
            return false;
        }

        $time = $ar[1];
        $pw_enc = $ar[2];

        // PWƍ
        if ($pw_enc == md5($this->user_u . ':' . $time . ':' . $this->pass_x)) {
            return true;
        } else {
            return false;
        }
    }

    // }}}
    // {{{ getMd5CryptKey()

    /**
     * md5_encrypt, md5_decrypt ̂߂ɃNvgL[𓾂
     *
     * @return string
     */
    public function getMd5CryptKey()
    {
        //return $_SERVER['SERVER_NAME'] . $_SERVER['HTTP_USER_AGENT'] . $_SERVER['SERVER_SOFTWARE'];
        return $_SERVER['SERVER_NAME'] . $_SERVER['SERVER_SOFTWARE'];
    }

    // }}}
    // {{{ _checkIp()

    /**
     * IPAhXш̌؂
     *
     * @param string $type
     * @return bool
     */
    private function _checkIp($type)
    {
        if (!class_exists('HostCheck', false)) {
            require P2_LIB_DIR . '/HostCheck.php';
        }

        // PHP̓NXE\bhE֐̑啶ʂȂ...
        $method = 'isAddr' . ucfirst(strtolower($type));
        if (method_exists('HostCheck', $method)) {
            return HostCheck::$method();
        }

        // ɗȂ悤ɈLq邱
        p2die('Login::_checkIp() Failure', "Invalid argument ({$type}).");
    }

    // }}}
}

// }}}

/*
 * Local Variables:
 * mode: php
 * coding: cp932
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: nil
 * End:
 */
// vim: set syn=php fenc=cp932 ai et ts=4 sw=4 sts=4 fdm=marker:
