<?php
/**
 * rep2expack - ImageCache2
 */

require_once P2EX_LIB_DIR . '/ic2/findexec.inc.php';
require_once P2EX_LIB_DIR . '/ic2/loadconfig.inc.php';
require_once P2EX_LIB_DIR . '/ic2/DataObject/Common.php';
require_once P2EX_LIB_DIR . '/ic2/DataObject/Images.php';

// {{{ IC2_Thumbnailer

class IC2_Thumbnailer
{
    // {{{ constants

    const SIZE_SOURCE   = 0; // ic2.php ̂߁A֋Xݒ肵Ă邪AD܂Ȃ
    const SIZE_PC       = 1;
    const SIZE_MOBILE   = 2;
    const SIZE_INTERMD  = 3;

    const SIZE_DEFAULT  = 1;

    // }}}
    // {{{ properties

    public $db;            // @var object  PEAR DB_{phptype}̃CX^X
    public $ini;           // @var array   ImageCache2̐ݒ
    public $mode;          // @var int     TlC̎
    public $cachedir;      // @var string  ImageCache2̃LbVۑfBNg
    public $sourcedir;     // @var string  \[XۑfBNg
    public $thumbdir;      // @var string  TlCۑfBNg
    public $driver;        // @var string  C[WhCo̎
    public $epeg;          // @var bool    Epegp\ۂ
    public $magick;        // @var string  ImageMagick̃pX
    public $magick6;       // @var bool    ImageMagick6ȏォۂ
    public $max_width;     // @var int     TlC̍ő啝
    public $max_height;    // @var int     TlC̍ő卂
    public $type;          // @var string  TlC̉摜`iJPEGPNGj
    public $quality;       // @var int     TlC̕i
    public $bgcolor;       // @var mixed   TlC̔wiF
    public $resize;        // @var bolean  摜TCY邩ۂ
    public $rotate;        // @var int     摜]pxi]ȂƂ0j
    public $trim;          // @var bolean  摜g~O邩ۂ
    public $coord;         // @var array   摜g~Ó͈ig~OȂƂfalsej
    public $found;         // @var array   IC2_DataObject_ImagesŃNG𑗐M
    public $dynamic;       // @var bool    I邩ۂitruêƂʂt@CɕۑȂj
    public $intermd;       // @var string  Iɗp钆ԃC[W̃pXi\[X璼ڐƂfalsej
    public $buf;           // @var string  I摜f[^
    // @var array $default_options,    ĨIvV
    public $default_options = array(
        'quality' => null,
        'width'   => null,
        'height'  => null,
        'rotate'  => 0,
        'trim'    => false,
        'intermd' => false,
    );
    // @var array $mimemap, MIME^CvƊgq̑Ή\
    public $mimemap = array('image/jpeg' => '.jpg', 'image/png' => '.png', 'image/gif' => '.gif');

    // }}}
    // {{{ constructor

    /**
     * RXgN^
     *
     * @param int $mode
     * @param array $dynamic_options
     */
    public function __construct($mode = self::SIZE_DEFAULT, array $dynamic_options = null)
    {
        if ($dynamic_options) {
            $options = array_merge($this->default_options, $dynamic_options);
            $this->dynamic = true;
            $this->intermd = $options['intermd'];
        } else {
            $options = $this->default_options;
            $this->dynamic = false;
            $this->intermd = false;
        }

        // ݒ
        $this->ini = ic2_loadconfig();

        // f[^x[Xɐڑ
        $icdb = new IC2_DataObject_Images;
        $this->db = &$icdb->getDatabaseConnection();
        if (DB::isError($this->db)) {
            $this->error($this->db->getMessage());
        }

        // TlC[h
        switch ($mode) {
            case self::SIZE_SOURCE:
            case self::SIZE_PC:
                $this->mode = self::SIZE_PC;
                $setting = $this->ini['Thumb1'];
                break;
            case self::SIZE_MOBILE:
                $this->mode = self::SIZE_MOBILE;
                $setting = $this->ini['Thumb2'];
                break;
            case self::SIZE_INTERMD:
                $this->mode = self::SIZE_INTERMD;
                $setting = $this->ini['Thumb3'];
                break;
            default:
                $this->error('ȃTlC[hłB');
        }

        // C[WhCo
        $driver = strtolower($this->ini['General']['driver']);
        $this->driver = $driver;
        $this->magick6 = false;
        switch ($driver) {
            case 'imagemagick6': // ImageMagick6  convert R}h
                $this->driver = 'imagemagick';
                $this->magick6 = true;
            case 'imagemagick': // ImageMagick  convert R}h
                $searchpath = $this->ini['General']['magick'];
                if (!findexec('convert', $searchpath)) {
                    $this->error('ImageMagickg܂B');
                }
                if ($searchpath) {
                    $this->magick = $searchpath . DIRECTORY_SEPARATOR . 'convert';
                } else {
                    $this->magick = 'convert';
                }
                break;
            case 'gd': // PHP  GD g@\
            case 'imagick': // PHP  ImageMagick g@\
            case 'imlib2': // PHP  Imlib2 g@\
                if (!extension_loaded($driver)) {
                    $this->error($driver . 'GNXeVg܂B');
                }
                break;
            default:
                $this->error('ȃC[WhCołB');
        }

        // fBNgݒ
        $this->cachedir   = $this->ini['General']['cachedir'];
        $this->sourcedir  = $this->cachedir . '/' . $this->ini['Source']['name'];
        $this->thumbdir   = $this->cachedir . '/' . $setting['name'];

        // TlC̉摜`EEE]pxEiݒ
        $rotate = (int) $options['rotate'];
        if (abs($rotate) < 4) {
            $rotate = $rotate * 90;
        }
        $rotate = ($rotate < 0) ? ($rotate % 360) + 360 : $rotate % 360;
        $this->rotate = ($rotate % 90 == 0) ? $rotate : 0;
        if ($options['width'] >= 1 && $options['height'] >= 1) {
            $setting['width']  = $options['width'];
            $setting['height'] = $options['height'];
        }
        if ($this->rotate % 180 == 90) {
            $this->max_width  = (int) $setting['height'];
            $this->max_height = (int) $setting['width'];
        } else {
            $this->max_width  = (int) $setting['width'];
            $this->max_height = (int) $setting['height'];
        }
        if (is_null($options['quality'])) {
            $this->quality = (int) $setting['quality'];
        } else {
            $this->quality = (int) $options['quality'];
        }
        if (0 < $this->quality && $this->quality <= 100) {
            $this->type = '.jpg';
        } else {
            $this->type = '.png';
            $this->quality = 0;
        }
        $this->trim = (bool) $options['trim'];

        // Epeggp
        if ($this->ini['General']['epeg'] && extension_loaded('epeg') &&
            !$this->dynamic && $this->type == '.jpg' &&
            $this->quality <= $this->ini['General']['epeg_quality_limit'])
        {
            $this->epeg = true;
        } else {
            $this->epeg = false;
        }

        // TlC̔wiFݒ
        if (preg_match('/^#?([0-9A-F]{2})([0-9A-F]{2})([0-9A-F]{2})$/i', // RGBeF216i
                       $this->ini['General']['bgcolor'], $c)) {
            $r = hexdec($c[1]);
            $g = hexdec($c[2]);
            $b = hexdec($c[3]);
        } elseif (preg_match('/^#?([0-9A-F])([0-9A-F])([0-9A-F])$/i', // RGBeF116i
                  $this->ini['General']['bgcolor'], $c)) {
            $r = hexdec($c[1] . $c[1]);
            $g = hexdec($c[2] . $c[2]);
            $b = hexdec($c[3] . $c[3]);
        } elseif (preg_match('/^(\d{1,3}),(\d{1,3}),(\d{1,3})$/', // RGBeF1`310i
                  $this->ini['General']['bgcolor'], $c)) {
            $r = max(0, min(intval($c[1]), 255));
            $g = max(0, min(intval($c[2]), 255));
            $b = max(0, min(intval($c[3]), 255));
        } else {
            $r = null;
            $g = null;
            $b = null;
        }
        $this->bgcolor = array($r, $g, $b);
    }

    // }}}
    // {{{ convert()

    /**
     * TlC쐬
     *
     * @return  string|bool|PEAR_Error
     *          TlC𐶐EۑɐƂATlC̃pX
     *          e|ETlC̐ɐƂAtrue
     *          sƂ PEAR_Error
     */
    public function convert($size, $md5, $mime, $width, $height, $force = false)
    {
        // 摜
        if (!empty($this->intermd) && file_exists($this->intermd)) {
            $src    = realpath($this->intermd);
            $csize  = getimagesize($this->intermd);
            $width  = $csize[0];
            $height = $csize[1];
        } else {
            $src = $this->srcPath($size, $md5, $mime, true);
        }
        $thumbURL = $this->thumbPath($size, $md5, $mime);
        $thumb = $this->thumbPath($size, $md5, $mime, true);
        if ($src == false) {
            $error = PEAR::raiseError("MIME^CvB({$mime})");
            return $error;
        } elseif (!file_exists($src)) {
            $error = PEAR::raiseError("\[X摜LbVĂ܂B({$src})");
            return $error;
        }
        if (!$force && !$this->dynamic && file_exists($thumb)) {
            return $thumbURL;
        }
        $thumbdir = dirname($thumb);
        if (!is_dir($thumbdir) && !@mkdir($thumbdir)) {
            $error = PEAR::raiseError("fBNg쐬ł܂łB({$thumbdir})");
            return $error;
        }

        // TCYlȉŉ]ȂA摜`Ȃ΂̂܂܃Rs[
        // --- gтŕ\łȂƂ̂ŕAƃTlC
        /*if ($this->resize == false && $this->rotate == 0 && $this->type == $this->mimemap[$mime]) {
            if (@copy($src, $thumb)) {
                return $thumbURL;
            } else {
                $error = PEAR::raiseError("摜Rs[ł܂łB({$src} -&gt; {$thumb})");
                return $error;
            }
        }*/

        // EpegŃTlC쐬
        if ($mime == 'image/jpeg' && $this->epeg) {
            $dst = ($this->dynamic) ? '' : $thumb;
            $result = epeg_thumbnail_create($src, $dst, $this->max_width, $this->max_height, $this->quality);
            if ($result == false) {
                $error = PEAR::raiseError("TlC쐬ł܂łB({$src} -&gt; {$dst})");
                return $error;
            }
            if ($this->dynamic) {
                $this->buf = $result;
            }
            return $thumbURL;
        }

        // o̓TCYvZ
        $size = array('w' => $width, 'h' => $height);
        list($size['tw'], $size['th']) = $this->calc($width, $height, true);
        if (is_array($this->coord)) {
            $size['sx'] = $this->coord['x'][0];
            $size['sy'] = $this->coord['y'][0];
            $size['sw'] = $this->coord['x'][1];
            $size['sh'] = $this->coord['y'][1];
        } else {
            $size['sx'] = 0;
            $size['sy'] = 0;
            $size['sw'] = $width;
            $size['sh'] = $height;
        }

        // C[WhCoɃTlC쐬
        $convertorClass = 'Thumbnailer_' . ucfirst(strtolower($this->driver));
        if ($convertorClass == 'Thumbnailer_Imagick') {
            if (!class_exists('Imagick', false)) {
                $convertorClass = 'Thumbnailer_Imagick09';
            }
        }

        if (!class_exists($convertorClass, false)) {
            require dirname(__FILE__) . DIRECTORY_SEPARATOR .
                    str_replace('_', DIRECTORY_SEPARATOR, $convertorClass) . '.php';
        }

        $convertor = new $convertorClass();
        $convertor->setBgColor($this->bgcolor[0], $this->bgcolor[1], $this->bgcolor[2]);
        $convertor->setHttp(true);
        if ($this->type == '.png') {
            $convertor->setPng(true);
        } else {
            $convertor->setQuality($this->quality);
        }
        $convertor->setResampling($this->resize);
        $convertor->setRotation($this->rotate);
        $convertor->setTrimming($this->trim);
        if ($this->driver == 'imagemagick') {
            $convertor->setImageMagickConvertPath($this->magick);
            $convertor->setImageMagick6($this->magick6);
        }

        if ($this->dynamic) {
            $result = $convertor->capture($src, $size);
            if (is_string($result)) {
                $this->buf = $result;
            }
        } else {
            $result = $convertor->save($src, $thumb, $size);
        }

        if (PEAR::isError($result)) {
            return $result;
        }
        return $thumbURL;
    }

    // }}}
    // {{{ utility methods
    // {{{ calc()

    /**
     * TlCTCYvZ
     */
    public function calc($width, $height, $return_array = false)
    {
        // ftHglEtOݒ
        $t_width  = $width;
        $t_height = $height;
        $this->resize = false;
        $this->coord  = false;

        // \[XTlC̍őTCY菬ƂA\[X̑傫̂܂ܕԂ
        if ($width <= $this->max_width && $height <= $this->max_height) {
            // TCYEg~OƂɖ
            if ($return_array) {
                return array((int)$t_width, (int)$t_height);
            } else {
                return sprintf('%dx%d', $t_width, $t_height);
            }
        }

        // cǂɍ킹邩𔻒iőTCY艡 = ɍ킹j
        if (($width / $height) >= ($this->max_width / $this->max_height)) {
            // ɍ킹
            $main = $width;
            $sub  = $height;
            $max_main = $this->max_width;
            $max_sub  = $this->max_height;
            $t_main = &$t_width;  // $t_main$t_subTlCTCY
            $t_sub  = &$t_height; // t@XɂĂ̂
            $c_main = 'x';
            $c_sub  = 'y';
        } else {
            // cɍ킹
            $main = $height;
            $sub  = $width;
            $max_main = $this->max_height;
            $max_sub  = $this->max_width;
            $t_main = &$t_height;
            $t_sub  = &$t_width;
            $c_main = 'y';
            $c_sub  = 'x';
        }

        // TlCTCYƕϊtO
        $t_main = $max_main;
        if ($this->trim) {
            // g~O
            $this->coord = array($c_main => array(0, $main), $c_sub => array(0, $sub));
            $ratio = $t_sub / $max_sub;
            if ($ratio <= 1) {
                // \[XTlC̍őTCY菬ƂAkɃg~O
                // $t_main == $max_main, $t_sub == $sub
                // ceil($sub * ($t_main / $t_sub)) = ceil($sub * $t_main / $sub) = $t_main = $max_main
                $c_length = $max_main;
            } elseif ($ratio < 1.05) {
                // kɂ߂ďƂA掿򉻂邽߂ɏkɃg~O
                $this->coord[$c_sub][0] = floor(($t_sub - $max_sub) / 2);
                $t_sub = $max_sub;
                $c_length = $max_main;
            } else {
                // TlCTCYςɎ܂悤ɏkg~O
                $this->resize = true;
                $t_sub = $max_sub;
                $c_length = ceil($sub * ($t_main / $t_sub));
            }
            $this->coord[$c_main] = array(floor(($main - $c_length) / 2), $c_length);
        } else {
            // AXyNgێ܂܏kAg~O͂Ȃ
            $this->resize = true;
            $t_sub = round($max_main * ($sub / $main));
        }

        // TlCTCYԂ
        if ($return_array) {
            return array((int)$t_width, (int)$t_height);
        } else {
            return sprintf('%dx%d', $t_width, $t_height);
        }
    }

    // }}}
    // {{{ srcPath()

    /**
     * \[X摜̃pX擾
     */
    public function srcPath($size, $md5, $mime, $FSFullPath = false)
    {
        $directory = $this->getSubDir($this->sourcedir, $size, $md5, $mime, $FSFullPath);
        if (!$directory) {
            return false;
        }

        $basename = $size . '_' . $md5 . $this->mimemap[$mime];

        return $directory . ($FSFullPath ? DIRECTORY_SEPARATOR : '/') . $basename;
    }

    // }}}
    // {{{ thumbPath()

    /**
     * TlC̃pX擾
     */
    public function thumbPath($size, $md5, $mime, $FSFullPath = false)
    {
        $directory = $this->getSubDir($this->thumbdir, $size, $md5, $mime, $FSFullPath);
        if (!$directory) {
            return false;
        }

        $basename = $size . '_' . $md5;
        if ($this->rotate) {
            $basename .= '_' . str_pad($this->rotate, 3, 0, STR_PAD_LEFT);
        }
        if ($this->trim) {
            $basename .= '_tr';
        }
        $basename .= $this->type;

        return $directory . ($FSFullPath ? DIRECTORY_SEPARATOR : '/') . $basename;
    }

    // }}}
    // {{{ getSubDir()

    /**
     * 摜ۑTufBNg̃pX擾
     */
    public function getSubDir($basedir, $size, $md5, $mime, $FSFullPath = false)
    {
        if (!is_dir($basedir)) {
            return false;
        }

        $dirID = $this->dirID($size, $md5, $mime);

        if ($FSFullPath) {
            $directory = realpath($basedir) . DIRECTORY_SEPARATOR . $dirID;
        } else {
            $directory = $basedir . '/' . $dirID;
        }

        return $directory;
    }

    // }}}
    // {{{ dirID()

    /**
     * 摜1000ƂɃCNgfBNgID擾
     */
    public function dirID($size = null, $md5 = null, $mime = null)
    {
        if ($size && $md5 && $mime) {
            $icdb = new IC2_DataObject_Images;
            $icdb->whereAddQUoted('size', '=', $size);
            $icdb->whereAddQuoted('md5',  '=', $md5);
            $icdb->whereAddQUoted('mime', '=', $mime);
            $icdb->orderByArray(array('id' => 'ASC'));
            if ($icdb->find(true)) {
                $this->found = $icdb->toArray();
                return str_pad(ceil($icdb->id / 1000), 5, 0, STR_PAD_LEFT);
            }
        }
        $sql = 'SELECT MAX(' . $this->db->quoteIdentifier('id') . ') + 1 FROM '
             . $this->db->quoteIdentifier($this->ini['General']['table']) . ';';
        $nextid = &$this->db->getOne($sql);
        if (DB::isError($nextid) || !$nextid) {
            $nextid = 1;
        }
        return str_pad(ceil($nextid / 1000), 5, 0, STR_PAD_LEFT);
    }

    // }}}
    // }}}
    // {{{ error()

    /**
     * G[bZ[W\ďI
     */
    public function error($message = '')
    {
        echo <<<EOF
<html>
<head><title>ImageCache::Error</title></head>
<body>
<p>{$message}</p>
</body>
</html>
EOF;
        exit;
    }

    // }}}
}

// }}}

/*
 * Local Variables:
 * mode: php
 * coding: cp932
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: nil
 * End:
 */
// vim: set syn=php fenc=cp932 ai et ts=4 sw=4 sts=4 fdm=marker:
