<?php
/**
 * Thumbnailer_Imagick09
 * PHP Version 5
 */

require_once dirname(__FILE__) . '/Common.php';

// {{{ Thumbnailer_Imagick09

/**
 * Image manipulation class which uses imagick php extension version 0.9.13 or earlier.
 *
 * @deprecated
 */
class Thumbnailer_Imagick09 extends Thumbnailer_Common
{
    // {{{ save()

    /**
     * Convert and save.
     *
     * @param string $source
     * @param string $thumbnail
     * @param array $size
     * @return boolean
     * @throws PEAR_Error
     */
    public function save($source, $thumbnail, $size)
    {
        $dst = $this->_convert($source, $size);
        // TlCۑ
        if ($this->getQuality() > 0) {
            imagick_setcompressionquality($dst, $this->getQuality());
        }
        $prefix = (($this->isPng()) ? 'png' : 'jpeg') . ':';
        $result = imagick_writeimage($dst, $prefix.$thumbnail);
        if (!$result) {
            $reason = imagick_failedreason($dst);
            $detail = imagick_faileddescription($dst);
            $retval = PEAR::raiseError("Failed to create a thumbnail. ({$thumbnail}:{$reason}:{$detail})");
        } else {
            $retval = true;
        }
        imagick_destroyhandle($dst);
        return $retval;
    }

    // }}}
    // {{{ capture()

    /**
     * Convert and capture.
     *
     * imagick_image2blob() ł͂܂Ȃ̂
     * ꎞt@Cɏof[^ǂݍ
     *
     * @param string $source
     * @param array $size
     * @return string
     * @throws PEAR_Error
     */
    public function capture($source, $size)
    {
        $dst = $this->_convert($source, $size);
        // TlC쐬
        if ($this->getQuality() > 0) {
            imagick_setcompressionquality($dst, $this->getQuality());
        }
        $prefix = (($this->isPng()) ? 'png' : 'jpeg') . ':';
        $tempfile = $this->_tempnam();
        $result = imagick_writeimage($dst, $prefix.$tempfile);
        if (!$result) {
            $reason = imagick_failedreason($dst);
            $detail = imagick_faileddescription($dst);
            $retval = PEAR::raiseError("Failed to create a thumbnail. ({$thumbnail}:{$reason}:{$detail})");
        } else {
            $retval = file_get_contents($tempfile);
        }
        imagick_destroyhandle($dst);
        return $retval;
    }

    // }}}
    // {{{ output()

    /**
     * Convert and output.
     *
     * imagick_image2blob() ł͂܂Ȃ̂
     * ꎞt@CɏoAreadfile() 
     *
     * @param string $source
     * @param string $name
     * @param array $size
     * @return boolean
     * @throws PEAR_Error
     */
    public function output($source, $name, $size)
    {
        $dst = $this->_convert($source, $size);
        // TlCo
        if ($this->getQuality()) {
            imagick_setcompressionquality($dst, $this->getQuality());
        }
        $prefix = (($this->isPng()) ? 'png' : 'jpeg') . ':';
        $tempfile = $this->_tempnam();
        $result = imagick_writeimage($dst, $prefix.$tempfile);
        if (!$result) {
            $reason = imagick_failedreason($dst);
            $detail = imagick_faileddescription($dst);
            $retval = PEAR::raiseError("Failed to create a thumbnail. ({$name}:{$reason}:{$detail})");
        } else {
            $this->_httpHeader($name, filesize($tempfile));
            readfile($tempfile);
            $retval = true;
        }
        imagick_destroyhandle($dst);
        return $retval;
    }

    // }}}
    // {{{ _convert()

    /**
     * Image conversion abstraction.
     *
     * @param string $source
     * @param array $size
     * @return resource imagick handle
     */
    protected function _convert($source, $size)
    {
        extract($size);
        // \[X̃C[WXg[擾
        $src = imagick_readimage($source);
        if (!is_resource($src) || imagick_iserror($src)) {
            if (is_resource($src)) {
                $reason = imagick_failedreason($src);
                $detail = imagick_faileddescription($src);
                imagick_destroyhandle($src);
            }
            $error = PEAR::raiseError("Failed to load the image. ({$source}:{$reason}:{$detail})");
            return $error;
        }
        // TlC̃C[WXg[쐬
        $bgcolor = $this->getBgColor();
        $bg = sprintf('rgb(%d,%d,%d)', $bgcolor[0], $bgcolor[1], $bgcolor[2]);
        $dst = imagick_getcanvas($bg, $tw, $th);
        // \[XTCYATlCɃRs[
        if ($this->doesTrimming()) {
            imagick_crop($src, $sx, $sy, $sw, $sh);
        }
        if ($this->doesResampling()) {
            imagick_scale($src, $tw, $th, '!');
        }
        imagick_composite($dst, IMAGICK_COMPOSITE_OP_ATOP, $src, 0, 0);
        imagick_destroyhandle($src);
        // ]
        if ($degrees = $this->getRotation()) {
            imagick_rotate($dst, $degrees);
        }
        return $dst;
    }

    // }}}
}

// }}}

/*
 * Local Variables:
 * mode: php
 * coding: cp932
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: nil
 * End:
 */
// vim: set syn=php fenc=cp932 ai et ts=4 sw=4 sts=4 fdm=marker:
