<?php
/* vim: set fileencoding=cp932 autoindent noexpandtab ts=4 sw=4 sts=0 fdm=marker: */
/* mi: charset=Shift_JIS */
/*
	p2 - BrdCtl -- XgRg[NX for menu.php
*/

require_once (P2_LIBRARY_DIR . '/p2util.class.php');
require_once (P2_LIBRARY_DIR . '/filectl.class.php');
require_once (P2_LIBRARY_DIR . '/brdmenu.class.php');

/**
* Xg Rg[ NX
*/
class BrdCtl{

	/**
	 * boardSēǂݍ
	 */
	function read_brds()
	{
		$brd_menus_dir = BrdCtl::read_brd_dir();
		$brd_menus_online = BrdCtl::read_brd_online();
		if (is_array($brd_menus_dir) && is_array($brd_menus_online)) {
			$brd_menus = array_merge($brd_menus_dir, $brd_menus_online);
		} elseif (is_array($brd_menus_dir)) {
			$brd_menus = $brd_menus_dir;
		} elseif (is_array($brd_menus_online)) {
			$brd_menus = $brd_menus_online;
		} else {
			$brd_menus = array();
		}
		return $brd_menus;
	}

	/**
	 * boardfBNg𑖍ēǂݍ
	 */
	function read_brd_dir()
	{
		global $_info_msg_ht;

		$brd_menus = array();
		$brd_dir = './board';

		if (is_dir($brd_dir) && ($cdir = dir($brd_dir))) {
			// fBNg
			while ($entry = $cdir->read()) {
				if (preg_match('/^\./', $entry)) {
					continue;
				}
				$filepath = $brd_dir.'/'.$entry;
				if ($data = file($filepath)) {
					$aBrdMenu = &new BrdMenu;	// NX BrdMenu ̃IuWFNg𐶐
					$aBrdMenu->setBrdMatch($filepath);	// p^[}b``o^
					$aBrdMenu->setBrdList($data);	// JeS[ƔZbg
					$brd_menus[] = &$aBrdMenu;
				} else {
					$_info_msg_ht .= "<p>p2 error: Xg {$entry} ǂݍ߂܂łB</p>\n";
				}
			}
			$cdir->close();
		}

		return $brd_menus;
	}

	/**
	 * ICXgǍ
	 */
	function read_brd_online()
	{
		global $_conf, $_info_msg_ht;

		$brd_menus = array();

		if ($_conf['brdfile_online']) {
			$cachefile = P2Util::cacheFileForDL($_conf['brdfile_online']);

			$noDL = false;
			$isNewDL = false;
			$read_html_flag = false;

			// LbVꍇ
			if (file_exists($cachefile.'.p2.brd')) {
				// norefreshȂDLȂ
				if (!empty($_GET['nr'])) {
					$noDL = true;
				// LbV̍XVw莞ԈȓȂDLȂ
				} elseif (@filemtime($cachefile.'.p2.brd') > time() - 60 * 60 * $_conf['menu_dl_interval']) {
					$noDL = true;
				}
			}

			// DLȂ
			if ($noDL ) {
				;
			// DL
			} else {
				//echo 'DL!<br>';//
				$brdfile_online_res = &P2Util::fileDownload($_conf['brdfile_online'], $cachefile);
				if ($brdfile_online_res->is_success() && $brdfile_online_res->code != '304') {
					$isNewDL = true;
				}
			}

			// html`Ȃ
			if (preg_match('/html?$/', $_conf['brdfile_online'])) {

				// XVĂVKLbV쐬
				if ($isNewDL) {
					//echo 'NEW!<br>';//
					$aBrdMenu = &new BrdMenu; // NX BrdMenu ̃IuWFNg𐶐
					$aBrdMenu->makeBrdFile($cachefile); // .p2.brdt@C𐶐
					$brd_menus[] = &$aBrdMenu;
					$read_html_flag = true;
				}

				if (file_exists($cachefile.'.p2.brd')) {
					$cashe_brd = $cachefile.'.p2.brd';
				} else {
					$cashe_brd = $cachefile;
				}

			} else {
				$cashe_brd = $cachefile;
			}

			if (!$read_html_flag) {
				if ($data = @file($cashe_brd)) {
					$aBrdMenu = &new BrdMenu; // NX BrdMenu ̃IuWFNg𐶐
					$aBrdMenu->setBrdMatch($cashe_brd); // p^[}b``o^
					$aBrdMenu->setBrdList($data); // JeS[ƔZbg
					if ($aBrdMenu->num) {
						$brd_menus[] = &$aBrdMenu;
					} else {
						$_info_msg_ht .=  "<p>p2 G[: {$cashe_brd} j[𐶐邱Ƃ͂ł܂łB</p>\n";
					}
				} else {
					$_info_msg_ht .=  "<p>p2 G[: {$cachefile} ͓ǂݍ߂܂łB</p>\n";
				}
			}

		}

		return $brd_menus;
	}

}

?>
