<?php
/* vim: set fileencoding=cp932 ai et ts=4 sw=4 sts=0 fdm=marker: */
/* mi: charset=Shift_JIS */

// {{{ class NgAbornChk

/**
 * p2expack - NG/ځ[񔻒NX
 * ShowThreadNXɌp
*/
class NgAbornChk
{
    // {{{ properties

    // XbhIuWFNg󂯎vpeB
    var $host;
    var $bbs;
    var $key;
    var $rescount;

    // p[Xςdat̔z
    var $pDatLines;

    // ځ[Ώۂ̃Xԍۑz
    var $aborn_hit_cache;

    // NGΏۂ̃Xԍۑz
    var $ng_hit_cache;

    // Aځ[Ώۂ̃Xԍۑz
    var $chain_aborn_resnum;

    // ANGΏۂ̃Xԍۑz
    var $chain_ng_resnum;

    // A郌Xԍ̃LbV
    var $chain_pre_num;
    var $chain_pre_refs;

    // }}}
    // {{{ constructor

    /**
     * RXgN^ (PHP4 style)
     */
    function NgAbornChk(&$aThread, $pDatLines)
    {
        $this->__construct($aThread, $pDatLines);
    }

    /**
     * RXgN^ (PHP5 style)
     */
    function __construct(&$aThread, $pDatLines)
    {
        $this->host = $aThread->host;
        $this->bbs  = $aThread->bbs;
        $this->key  = $aThread->key;
        $this->rescount = $aThread->rescount;
        $this->pDatLines    = $pDatLines;
        $this->aborn_hit_cache      = array();
        $this->ng_hit_cache         = array();
        $this->chain_aborn_resnum   = array();
        $this->chain_ng_resnum      = array();
    }

    // }}}
    // {{{ ngAbornPrepare()

    /**
     * NG/ځ[`FbNpɃtH[}bg
     */
    function ngAbornPrepare($resnum, $fname)
    {
        switch ($fname) {
            case 'msg':
                $field = strip_tags($this->pDatLines[$resnum]['msg'], '<br>');
                break;
            case 'id':
                $field = $this->pDatLines[$resnum]['p_dateid']['id'];
                break;
            default:
                $field = strip_tags($this->pDatLines[$resnum][$fname]);
        }
        return $field;
    }

    // }}}
    // {{{ ngAbornWordCheck()

    /**
     * NG/ځ[񃏁[h`FbN
     */
    function ngAbornWordCheck($code, $resfield, $ic = FALSE)
    {
        global $ngaborns;

        $method = $ic ? 'stristr' : 'strstr';

        if (isset($ngaborns[$code]['data']) && is_array($ngaborns[$code]['data'])) {
            foreach ($ngaborns[$code]['data'] as $k => $v) {
                if (strlen($v['word']) == 0) {
                    continue;
                }
                // <֐:IvV>p^[ `̍s͐K\ƂĈ
                // oCiZ[tłȂi{ŃG[o邱Ƃĵereg()n͎gȂ
                if (preg_match('/^<(mb_ereg|preg_match|regex)(:[imsxeADSUXu]+)?>(.+)$/', $v['word'], $re)) {
                    // "regex"̂Ƃ͎ݒ
                    if ($re[1] == 'regex') {
                        if (P2_MBREGEX_AVAILABLE) {
                            $re_method = 'mb_ereg';
                            $re_pattern = $re[3];
                        } else {
                            $re_method = 'preg_match';
                            $re_pattern = '/' . str_replace('/', '\\/', $re[3]) . '/';
                        }
                    } else {
                        $re_method = $re[1];
                        $re_pattern = $re[3];
                    }
                    // 啶𖳎
                    if ($re[2] && strstr($re[2], 'i')) {
                        if ($re_method == 'preg_match') {
                            $re_pattern .= 'i';
                        } else {
                            $re_method .= 'i';
                        }
                    }
                    // }b`
                    if ($re_method($re_pattern, $resfield)) {
                        $this->ngAbornUpdate($code, $k);
                        return $v['word'];
                    //if ($re_method($re_pattern, $resfield, $matches)) {
                        //return htmlspecialchars($matches[0]);
                    }

                // Pɕ񂪊܂܂邩ǂ`FbN
                } elseif ($method($resfield, $v['word'])) {
                    $this->ngAbornUpdate($code, $k);
                    return $v['word'];
                }
            }
        }
        return FALSE;
    }

    // }}}
    // {{{ ngAbornUpdate()

    /**
     * NG/ځ[Ɖ񐔂XV
     */
    function ngAbornUpdate($code, $k)
    {
        global $ngaborns;

        if (isset($ngaborns[$code]['data'][$k])) {
            $v = &$ngaborns[$code]['data'][$k];
            $v['lasttime'] = date('Y/m/d G:i'); // HITԂXV
            if (empty($v['hits'])) {
                $v['hits'] = 1; // HIT
            } else {
                $v['hits']++;   // HIT񐔂XV
            }
        }
    }

    // }}}
    // {{{ abornResCheck()

    /**
     * 背X̓ځ[`FbN
     */
    function abornResCheck($host, $bbs, $key, $resnum)
    {
        global $ngaborns;

        $target = $host.'/'.$bbs.'/'.$key.'/'.$resnum;

        if (isset($ngaborns['aborn_res']['data']) && is_array($ngaborns['aborn_res']['data'])) {
            foreach ($ngaborns['aborn_res']['data'] as $k => $v) {
                if ($v['word'] == $target) {
                    $this->ngAbornUpdate('aborn_res', $k);
                    return TRUE;
                }
            }
        }
        return FALSE;
    }

    // }}}
    // {{{ abornCheck()

    /**
     * StB[h̓ځ[`FbN
     */
    function abornCheck($resnum, $is_chain = FALSE)
    {
        global $_exconf;

        if (isset($this->aborn_hit_cache[$resnum])) {
            return $this->aborn_hit_cache[$resnum];
        } elseif (!isset($this->pDatLines[$resnum])) {
            return $this->abornResultCache($resnum, FALSE);
        }

        // {{{ ߑłځ[`FbN

        if ($this->abornResCheck($this->host, $this->bbs, $this->key, $resnum)) {
            $this->chain_aborn_resnum[] = $resnum;
            return $this->abornResultCache($resnum, 'res');
        }

        // }}}
        // {{{ sځ[`FbN

        // ɂ͘AȂ
        if (!$is_chain && $_exconf['aborn']['break_aborn'] && !$_exconf['aborn']['break_aborn_ng'] &&
            $this->pDatLines[$resnum]['lines'] > $_exconf['aborn']['break_aborn']
        ) {
            //$this->chain_aborn_resnum[] = $resnum;    // sI[o[͘AΏۂɂȂ
            //return $this->abornResultCache($resnum, 'lines'); // ċAɂځ[񂳂Ȃ悤AʂLbVȂ
            return 'lines';
        }

        // }}}
        // {{{ L[[hځ[`FbN

        $fields = array('name', 'mail', 'id', 'msg');
        foreach ($fields as $fname) {
            if ($this->ngAbornWordCheck('aborn_'.$fname, $this->ngAbornPrepare($resnum, $fname)) !== FALSE) {
                $this->chain_aborn_resnum[] = $resnum;
                return $this->abornResultCache($resnum, $fname);
            }
        }

        // }}}

        if (!$_exconf['aborn']['chain_aborn']) {
            return $this->abornResultCache($resnum, FALSE);
        }

        // {{{ Aځ[`FbN

        $chain_aborn = FALSE;
        $chain_found = array();
        $refs = $this->getChainNums($resnum);   // QƂĂԍŁA菬
        if (!$refs) {
            return $this->abornResultCache($resnum, FALSE);
        }

        // AΏۂɓo^ĂȂ`FbN
        if ($chain_found = array_intersect($refs, $this->chain_aborn_resnum)) {
            $chain_aborn = TRUE;
        } else {
            // eQƃXԍċAIɃ`FbN
            foreach ($refs as $ref) {
                // $refs̓\[gĂ̂Ŏȏ̔ԍƁAŏI
                // getChainNums()ŃtB^Ôł͕̔sv
                /*if ($ref >= $resnum) {
                    break;
                }*/
                // ċA`FbNiċAA$is_chain͌̃Xԍj
                if ($ref == $is_chain) {
                    continue;
                }
                if ($this->abornCheck($ref, $resnum)) {
                    $chain_aborn = TRUE;
                    $chain_found[] = $ref;
                    break;
                }
            }
        }

        // o^
        if ($chain_aborn) {
            // Aځ[NGɂƂ
            if ($_exconf['aborn']['chain_aborn_ng']) {
                // kĘȂΏۂƂƂ
                if ($_exconf['aborn']['chain_ng'] == 2) {
                    $this->chain_ng_resnum[] = $resnum;
                }
                // ɂāANG`FbNƂɁuځ[񃌃XɃXvƂ
                $this->ngResultCache($resnum, array('aborn' => implode(',', $chain_found)));
                // ځ[ł͂Ȃ̂FALSEo^
                return $this->abornResultCache($resnum, FALSE);
            }
            // kĘȂΏۂƂƂ
            if ($_exconf['aborn']['chain_aborn'] == 2) {
                $this->chain_aborn_resnum[] = $resnum;
            }
            return $this->abornResultCache($resnum, 'chain');
        }

        // }}}

        return $this->abornResultCache($resnum, FALSE);
    }

    // }}}
    // {{{ ngCheck()

    /**
     * StB[hNG`FbN
     */
    function ngCheck($resnum, $is_chain = FALSE)
    {
        global $_exconf;

        if (isset($this->ng_hit_cache[$resnum])) {
            return $this->ng_hit_cache[$resnum];
        } elseif (!isset($this->pDatLines[$resnum])) {
            return $this->ngResultCache($resnum, array());
        }

        $ng_fields = array();
        $ng_only_line = FALSE;

        // {{{ sNG`FbN

        // ɂ͘AȂ
        if (!$is_chain && $_exconf['aborn']['break_aborn'] && $_exconf['aborn']['break_aborn_ng'] &&
            $this->pDatLines[$resnum]['lines'] > $_exconf['aborn']['break_aborn']
        ) {
            //$this->chain_aborn_resnum[] = $resnum;    // sI[o[͘AΏۂɂȂ
            $ng_fields['lines'] = $this->pDatLines[$resnum]['lines'];
            $ng_only_line = TRUE;
        }

        // }}}
        // {{{ L[[hNG`FbN

        $fields = array('name', 'mail', 'id', 'msg');
        foreach ($fields as $fname) {
            if (($found = $this->ngAbornWordCheck('ng_'.$fname, $this->ngAbornPrepare($resnum, $fname))) !== FALSE) {
                $this->chain_ng_resnum[] = $resnum;
                $ng_fields[$fname] = htmlspecialchars($found);
                $ng_only_line = FALSE;
            }
        }

        // }}}

        if ($ng_fields || !$_exconf['aborn']['chain_ng']) {
            if ($ng_only_line) {
                //$this->ngResultCache($resnum, array());   // ċANGƂȂ悤AʂLbVȂ
                return $ng_fields;
            }
            return $this->ngResultCache($resnum, $ng_fields);
        }

        // {{{ ANG`FbN

        $chain_ng = FALSE;
        $chain_found = array();
        $refs = $this->getChainNums($resnum);   // QƂĂԍŁA菬
        if (!$refs) {
            return $this->ngResultCache($resnum, array());
        }

        // AΏۂɓo^ĂȂ`FbN
        if ($chain_found = array_intersect($refs, $this->chain_ng_resnum)) {
            $chain_ng = TRUE;
        } else {
            // eQƃXԍċAIɃ`FbN
            foreach ($refs as $ref) {
                // $refs̓\[gĂ̂Ŏȏ̔ԍƁAŏI
                // getChainNums()ŃtB^Ôł͕̔sv
                /*if ($ref >= $resnum) {
                    break;
                }*/
                // ċA`FbNiċAA$is_chain͌̃Xԍj
                if ($ref == $is_chain) {
                    continue;
                }
                if ($this->ngCheck($ref, $resnum)) {
                    $chain_ng = TRUE;
                    $chain_found[] = $ref;
                    break;
                }
            }
        }


        // o^
        if ($chain_ng) {
            // kĘȂΏۂƂƂ
            if ($_exconf['aborn']['chain_ng'] == 2) {
                $this->chain_ng_resnum[] = $resnum;
            }
            $ng_fields['chain'] = implode(',', $chain_found);
        }

        // }}}

        return $this->ngResultCache($resnum, $ng_fields);
    }

    // }}}
    // {{{ ngAbornCheckAll()

    /**
     * SX̂ځ[/NG`FbN
     */
    function ngAbornCheckAll()
    {
        for ($i = 1; $i <= $this->rescount; $i++) {
            $this->abornCheck($i) || $this->ngCheck($i);
        }
    }

    // }}}
    // {{{ abornResultCache()

    /**
     * A`FbNpɂځ[`FbŇʂLbV
     */
    function abornResultCache($resnum, $result)
    {
        $this->aborn_hit_cache[$resnum] = $result;
        return $result;
    }

    // }}}
    // {{{ ngResultCache()

    /**
     * A`FbNpNG`FbŇʂLbV
     */
    function ngResultCache($resnum, $result)
    {
        $this->ng_hit_cache[$resnum] = $result;
        return $result;
    }

    // }}}
    // {{{ getChainNums()

    /**
     * A`FbNpɎQƃXԍO[v
     *
     * gƂ傫Xԍ͏
     */
    function getChainNums($resnum)
    {
        global $_exconf;

        // Xɑ΂ĘAłځ[NG`FbNƂ̓xԂȂ
        if ($resnum == $this->chain_pre_num) {
            return $this->chain_pre_refs;
        }

        // >>n >>x,y,z $resnum菬̂𒊏o
        $refs = array_filter($this->pDatLines[$resnum]['refs'], create_function('$n', "return (\$n < $resnum);"));

        // >>from-to WJ
        if ($_exconf['aborn']['chain_range'] && $this->pDatLines[$resnum]['refr']) {
            foreach ($this->pDatLines[$resnum]['refr'] as $refr) {
                // ܂肦ȂǁAÔ߃`FbN
                if (!isset($refr['from']) && !isset($refr['to'])) {
                    continue;
                }
                $x = (!empty($refr['from'])) ? max($refr['from'], 1) : 1;
                $y = (!empty($refr['to'])) ? min($refr['to'], $this->rescount) : $this->rescount;
                $z = min($y + 1, $resnum);
                for ($i = $x; $i < $z; $i++) {
                    $refs[] = $i;
                }
                // $refs傷̂h߁As
                $refs = array_unique($refs);
            }
        }

        sort($refs);

        $this->chain_pre_num = $resnum;
        $this->chain_pre_refs = $refs;
        return $refs;
    }

    // }}}
}

// }}}

?>
